/*
 * Decompiled with CFR 0.152.
 */
package bizrules;

import bizrules.AbstractElementProcessor;
import bizrules.BusinessRule;
import bizrules.BusinessRuleError;
import bizrules.registry.BusinessRuleRegistryAccess;
import com.gsl.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import processingError.ErrorProcessor;
import processingError.Location;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public abstract class AbstractBusinessRule
extends AbstractElementProcessor
implements BusinessRule,
ErrorProcessor {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    private String name;
    private final List<ElementReference> attachmentPoints = new ArrayList<ElementReference>();
    protected static final Logger LOGGER = LoggerFactory.getLogger("bizrules");
    private Set<String> declaredSubcodes;

    protected abstract String[] getInvocationPoints();

    public AbstractBusinessRule() {
        this.setupName();
        this.setupInvocationPoints();
    }

    @Override
    public void setBusinessRuleRegistryAccess(BusinessRuleRegistryAccess access) {
    }

    protected void setupName() {
        this.name = this.getClass().getSimpleName();
    }

    protected void setupInvocationPoints() {
        String[] attachmentPaths = this.getInvocationPoints();
        if (attachmentPaths != null) {
            String[] namespaces;
            for (String namespace : namespaces = this.getApplicableNamespaces()) {
                for (String path : attachmentPaths) {
                    this.getAttachmentPoints().add(SimpleElementReference.makeReference(namespace, path));
                }
            }
        }
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setRuleName(String name) {
        this.name = name;
    }

    @Override
    public List<ElementReference> getAttachmentPoints() {
        return this.attachmentPoints;
    }

    @Override
    public abstract boolean isActive();

    @Override
    public boolean handleError(DocumentError documentError) {
        BusinessRuleError newError = this.raiseError(documentError.getSubCode(), documentError.getValueInError(), documentError.getExtraInfo(), documentError.getLocation());
        newError.setChainedError(documentError);
        return true;
    }

    public boolean ignoreError(DocumentError documentError) {
        return true;
    }

    protected BusinessRuleError raiseError(String subCode, Object objectInError, Object extraInfo, Location location) {
        assert (this.getDeclaredSubcodes().contains(subCode)) : "Undeclared subcode: " + subCode + " in rule class: " + this.getClass().getName();
        BusinessRuleError businessRuleError = new BusinessRuleError(this, subCode);
        businessRuleError.setExtraInfo(extraInfo);
        businessRuleError.setLocation(location);
        businessRuleError.setValueInError(objectInError);
        businessRuleError.setErrorProcessor(this);
        if (this.getXPathLocator() != null) {
            businessRuleError.setXPathLocation(this.getXPathLocationString());
        }
        this.getErrorCollector().addError(businessRuleError);
        return businessRuleError;
    }

    protected String getXPathLocationString() {
        return this.getXPathLocator().toXPathLocatorString();
    }

    protected BusinessRuleError raiseError(String subCode, Object objectInError, Object extraInfo) {
        return this.raiseError(subCode, objectInError, extraInfo, null);
    }

    protected BusinessRuleError raiseError(String subCode, Object objectInError, Location location) {
        return this.raiseError(subCode, objectInError, null, location);
    }

    protected BusinessRuleError raiseError(String subCode, Location location) {
        return this.raiseError(subCode, null, location);
    }

    protected BusinessRuleError raiseError(String subCode, Object valueInError) {
        return this.raiseError(subCode, valueInError, null);
    }

    protected BusinessRuleError raiseError(String subCode) {
        return this.raiseError(subCode, null);
    }

    public Set<String> getDeclaredSubcodes() {
        if (this.declaredSubcodes == null) {
            String[] subcodes;
            this.declaredSubcodes = new HashSet<String>();
            for (String element : subcodes = this.getSubcodes()) {
                this.declaredSubcodes.add(element);
            }
            this.declaredSubcodes.add("suppress");
        }
        return this.declaredSubcodes;
    }

    public abstract String[] getSubcodes();

    protected String[] combine(String[] array1, String[] array2) {
        String[] dest = new String[array1.length + array2.length];
        System.arraycopy(array1, 0, dest, 0, array1.length);
        System.arraycopy(array2, 0, dest, array1.length, array2.length);
        return dest;
    }
}

