/*
 * Decompiled with CFR 0.152.
 */
package bizrules;

import bizrules.ElementProcessor;
import bizrules.binding.DocumentErrorBinding;
import bizrules.binding.DocumentEventBinding;
import bizrules.binding.ElementBinding;
import bizrules.binding.ErrorBinder;
import bizrules.binding.EventBinder;
import bizrules.binding.ValueBinder;
import java.util.List;
import processingError.NullErrorCollector;
import processingError.ProcessingErrorCollector;
import xmldoc.DocumentError;
import xmldoc.sax.XPathLocator;

public abstract class AbstractElementProcessor
implements ElementProcessor {
    private ProcessingErrorCollector errorCollector = NullErrorCollector.instance();
    private ValueBinder valueBinder;
    private EventBinder eventBinder;
    private ErrorBinder errorBinder;
    private XPathLocator xPathLocator = null;

    protected ValueBinder getValueBinder() {
        if (this.valueBinder == null) {
            this.valueBinder = new ValueBinder(this.getApplicableNamespaces(), this.getBoundObject());
        }
        return this.valueBinder;
    }

    protected EventBinder getEventBinder() {
        if (this.eventBinder == null) {
            this.eventBinder = new EventBinder(this.getApplicableNamespaces(), this.getBoundObject());
        }
        return this.eventBinder;
    }

    protected ErrorBinder getErrorBinder() {
        if (this.errorBinder == null) {
            this.errorBinder = new ErrorBinder(this.getApplicableNamespaces(), this.getBoundObject());
        }
        return this.errorBinder;
    }

    public boolean handleError(DocumentError error) {
        return false;
    }

    @Override
    public void postRegistrationSetup() {
    }

    protected Object getBoundObject() {
        return this;
    }

    protected abstract String[] getApplicableNamespaces();

    @Override
    public ProcessingErrorCollector getErrorCollector() {
        return this.errorCollector;
    }

    @Override
    public void setErrorCollector(ProcessingErrorCollector errorCollector) {
        this.errorCollector = errorCollector;
    }

    public void addValueBinding(String xpath, String propertyName) {
        this.getValueBinder().add(xpath, propertyName);
    }

    public void addEventBinding(String xpath, String methodName) {
        this.getEventBinder().add(xpath, methodName);
    }

    public void addErrorBinding(String xpath, String methodName) {
        this.getErrorBinder().add(xpath, methodName);
    }

    @Override
    public List<ElementBinding> getValueBindings() {
        this.initializeValueBindings();
        return this.getValueBinder().getBindings();
    }

    @Override
    public List<DocumentEventBinding> getEventBindings() {
        this.initializeEventBindings();
        return this.getEventBinder().getBindings();
    }

    @Override
    public List<DocumentErrorBinding> getErrorBindings() {
        this.initializeErrorBindings();
        return this.getErrorBinder().getBindings();
    }

    protected abstract void initializeEventBindings();

    protected abstract void initializeValueBindings();

    protected void initializeErrorBindings() {
    }

    public XPathLocator getXPathLocator() {
        return this.xPathLocator;
    }

    @Override
    public void setXPathLocator(XPathLocator pathLocator) {
        this.xPathLocator = pathLocator;
    }
}

