/*
 * Decompiled with CFR 0.152.
 */
package bizrules.binding;

import com.gsl.logging.LoggerFactory;
import com.gsl.util.reflection.BasicMethodLocator;
import com.gsl.util.reflection.MethodLocatorCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import xmldoc.DocumentError;
import xmldoc.ElementReference;

public class DocumentErrorBinding {
    private static final Logger logger = LoggerFactory.getLogger("bizrules.binding");
    private static MethodLocatorCache errorHandlerMethodLocator = new MethodLocatorCache(new BasicMethodLocator(new Class[]{DocumentError.class}, Boolean.TYPE));
    private static MethodLocatorCache isActiveLocator = new MethodLocatorCache(new BasicMethodLocator(new Class[0], Boolean.TYPE));
    private final Object boundObject;
    private final ElementReference reference;
    private final List<Method> errorHandlerMethods = new ArrayList<Method>();
    private Method isActiveMethod;

    public static void flush(ClassLoader classloader) {
        errorHandlerMethodLocator.flush(classloader);
    }

    public DocumentErrorBinding(Object boundObj, ElementReference ref, String methodName) {
        this.boundObject = boundObj;
        this.reference = ref;
        this.setupErrorHandlerMethod(methodName);
        this.setupIsActiveMethod();
    }

    public DocumentErrorBinding(Object boundObj, ElementReference ref, String[] methodNames) {
        this.boundObject = boundObj;
        this.reference = ref;
        for (String methodName : methodNames) {
            this.setupErrorHandlerMethod(methodName);
        }
        this.setupIsActiveMethod();
    }

    private void setupErrorHandlerMethod(String methodName) {
        Method errorHandlerMethod = errorHandlerMethodLocator.locateMethod(this.boundObject.getClass(), methodName);
        if (errorHandlerMethod == null) {
            logger.severe("No method 'public boolean " + methodName + "(DocumentError)' found  on class " + this.boundObject.getClass());
        } else {
            errorHandlerMethod.setAccessible(true);
            this.errorHandlerMethods.add(errorHandlerMethod);
        }
    }

    private void setupIsActiveMethod() {
        this.isActiveMethod = isActiveLocator.locateMethod(this.boundObject.getClass(), "isActive");
    }

    public boolean isActive() {
        boolean result = true;
        try {
            if (this.isActiveMethod != null) {
                Boolean bool = (Boolean)this.isActiveMethod.invoke(this.boundObject, new Object[0]);
                result = bool;
            }
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    public boolean invoke(DocumentError error) {
        boolean result = false;
        try {
            Method errorHandlerMethod;
            Boolean bool;
            Object[] args = new Object[]{error};
            Iterator<Method> i$ = this.errorHandlerMethods.iterator();
            while (i$.hasNext() && !(result = (bool = (Boolean)(errorHandlerMethod = i$.next()).invoke(this.boundObject, args)).booleanValue())) {
            }
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        return result;
    }

    public String toString() {
        return "DocumentErrorBinding [Ref='" + this.reference + "', methods=" + this.errorHandlerMethods + " on object '" + this.boundObject + "']";
    }

    public ElementReference getReference() {
        return this.reference;
    }

    public Object getBoundObject() {
        return this.boundObject;
    }
}

