/*
 * Decompiled with CFR 0.152.
 */
package bizrules.binding;

import bizrules.registry.DocumentEventDetail;
import com.gsl.logging.LoggerFactory;
import com.gsl.util.reflection.BasicMethodLocator;
import com.gsl.util.reflection.MethodLocatorCache;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import xmldoc.DocumentEventType;
import xmldoc.ElementReference;

public class DocumentEventBinding {
    private static final Logger logger = LoggerFactory.getLogger("coreXML.rules");
    private static MethodLocatorCache eventMethodLocator = new MethodLocatorCache(new BasicMethodLocator(new Class[]{DocumentEventDetail.class}, Void.TYPE));
    private final Object boundObject;
    private final ElementReference reference;
    private final String methodName;
    private Method eventMethod;
    private final DocumentEventType eventType;

    public static void flush(ClassLoader classloader) {
        eventMethodLocator.flush(classloader);
    }

    public DocumentEventBinding(Object boundObj, ElementReference ref, String methodName, DocumentEventType eventType) {
        this.boundObject = boundObj;
        this.reference = ref;
        this.methodName = methodName;
        this.eventType = eventType;
        this.setupEventMethod();
    }

    private void setupEventMethod() {
        this.eventMethod = eventMethodLocator.locateMethod(this.boundObject.getClass(), this.methodName);
        if (this.eventMethod == null) {
            logger.severe("No method 'public void " + this.methodName + "()' found  on class " + this.boundObject.getClass());
        } else {
            this.eventMethod.setAccessible(true);
        }
    }

    public void invoke(DocumentEventDetail detail) {
        try {
            this.eventMethod.invoke(this.boundObject, detail);
        }
        catch (InvocationTargetException e) {
            logger.log(Level.SEVERE, e.getTargetException().getMessage(), e.getTargetException());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String toString() {
        return "ElementEventBinding [Ref='" + this.reference + "', method='public void " + this.methodName + "()' on object '" + this.boundObject + "' for event '" + this.eventType + "']";
    }

    public DocumentEventType getEventType() {
        return this.eventType;
    }

    public ElementReference getReference() {
        return this.reference;
    }

    public int hashCode() {
        return this.reference.hashCode() ^ this.methodName.hashCode() ^ this.boundObject.hashCode() ^ this.eventType.hashCode();
    }

    public boolean equals(Object other) {
        boolean result = false;
        if (other != null && this.getClass() == other.getClass()) {
            DocumentEventBinding that = (DocumentEventBinding)other;
            result = this.boundObject.equals(that.boundObject) && this.methodName.equals(that.methodName) && this.reference.equals(that.reference) && this.eventType == that.eventType;
        }
        return result;
    }
}

