/*
 * Decompiled with CFR 0.152.
 */
package bizrules.binding;

import bizrules.binding.DocumentErrorBinding;
import java.util.ArrayList;
import java.util.List;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class ErrorBinder {
    private final List<DocumentErrorBinding> bindings = new ArrayList<DocumentErrorBinding>();
    private final Object boundObject;
    private final String[] namespaces;

    public ErrorBinder(String[] namespaces, Object boundObject) {
        this.namespaces = namespaces;
        this.boundObject = boundObject;
    }

    public ErrorBinder(String namespace, Object boundObject) {
        this(new String[]{namespace}, boundObject);
    }

    public void add(String xPath, String methodName) {
        for (String namespace : this.namespaces) {
            this.add(namespace, xPath, methodName);
        }
    }

    public void add(String xPath, String[] methodNames) {
        for (String namespace : this.namespaces) {
            ElementReference ref = SimpleElementReference.makeReference(namespace, xPath);
            DocumentErrorBinding binding = new DocumentErrorBinding(this.boundObject, ref, methodNames);
            this.bindings.add(binding);
        }
    }

    public void add(String namespace, String xPath, String methodName) {
        this.add(namespace, xPath, methodName, this.boundObject);
    }

    public void add(String xPath, String methodName, Object boundObj) {
        for (String element : this.namespaces) {
            this.add(element, xPath, methodName, boundObj);
        }
    }

    public void add(String namespace, String xPath, String methodName, Object boundObj) {
        this.add(SimpleElementReference.makeReference(namespace, xPath), methodName, boundObj);
    }

    public void add(ElementReference ref, String methodName) {
        this.add(ref, methodName, this.boundObject);
    }

    public void add(ElementReference ref, String methodName, Object boundObj) {
        this.add(new DocumentErrorBinding(boundObj, ref, methodName));
    }

    public void add(DocumentErrorBinding binding) {
        this.bindings.add(binding);
    }

    public List<DocumentErrorBinding> getBindings() {
        return this.bindings;
    }
}

