/*
 * Decompiled with CFR 0.152.
 */
package bizrules.binding;

import bizrules.binding.DocumentEventBinding;
import java.util.ArrayList;
import java.util.List;
import xmldoc.DocumentEventType;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class EventBinder {
    private final List<DocumentEventBinding> bindings = new ArrayList<DocumentEventBinding>();
    private final Object boundObject;
    private final String[] namespaces;

    public EventBinder(String[] namespaces, Object boundObject) {
        this.namespaces = namespaces;
        this.boundObject = boundObject;
    }

    public EventBinder(String namespace, Object boundObject) {
        this(new String[]{namespace}, boundObject);
    }

    public void add(String xPath, String methodName) {
        this.add(xPath, methodName, DocumentEventType.startElement);
    }

    public void add(String xPath, String methodName, DocumentEventType eventType) {
        for (String element : this.namespaces) {
            this.add(element, xPath, methodName, eventType);
        }
    }

    public void add(String namespace, String xPath, String methodName, DocumentEventType eventType) {
        this.add(namespace, xPath, methodName, this.boundObject, eventType);
    }

    public void add(String xPath, String methodName, Object boundObj, DocumentEventType eventType) {
        for (String element : this.namespaces) {
            this.add(element, xPath, methodName, boundObj, eventType);
        }
    }

    public void add(String namespace, String xPath, String methodName, Object boundObj, DocumentEventType eventType) {
        this.add(SimpleElementReference.makeReference(namespace, xPath), methodName, boundObj, eventType);
    }

    public void add(ElementReference ref, String methodName, DocumentEventType eventType) {
        this.add(ref, methodName, this.boundObject, eventType);
    }

    public void add(ElementReference ref, String methodName, Object boundObj, DocumentEventType eventType) {
        this.add(new DocumentEventBinding(boundObj, ref, methodName, eventType));
    }

    public void add(DocumentEventBinding binding) {
        this.bindings.add(binding);
    }

    public List<DocumentEventBinding> getBindings() {
        return this.bindings;
    }
}

