/*
 * Decompiled with CFR 0.152.
 */
package bizrules.binding;

import bizrules.binding.AbstractElementBinding;
import bizrules.binding.AttributesBinding;
import bizrules.binding.ElementBinding;
import bizrules.binding.ReferenceBinding;
import bizrules.binding.ValueAttributesBinding;
import bizrules.binding.ValueBinding;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class ValueBinder {
    private final List<ElementBinding> bindings = new ArrayList<ElementBinding>();
    private final Object boundObject;
    private final String[] namespaces;
    private static List<AbstractElementBinding.ElementBindingMaker<?>> bindingTypes = new ArrayList();

    public ValueBinder(String[] namespaces, Object boundObject) {
        this.namespaces = namespaces;
        this.boundObject = boundObject;
    }

    public ValueBinder(String namespace, Object boundObject) {
        this(new String[]{namespace}, boundObject);
    }

    public void add(String xPath, String propertyName) {
        for (String element : this.namespaces) {
            this.add(element, xPath, propertyName);
        }
    }

    public void add(String namespace, String xPath, String propertyName) {
        this.add(namespace, xPath, propertyName, this.boundObject);
    }

    public void add(String xPath, String propertyName, Object boundObj) {
        for (String element : this.namespaces) {
            this.add(element, xPath, propertyName, boundObj);
        }
    }

    public void add(String namespace, String xPath, String propertyName, Object boundObj) {
        this.add(SimpleElementReference.makeReference(namespace, xPath), propertyName, boundObj);
    }

    public void add(ElementReference ref, String propertyName) {
        this.add(ref, propertyName, this.boundObject);
    }

    public void add(ElementReference ref, String propertyName, Object boundObj) {
        for (AbstractElementBinding.ElementBindingMaker<?> maker : bindingTypes) {
            Method method = maker.locateMethod(boundObj, propertyName);
            if (method == null) continue;
            this.add((ElementBinding)maker.makeBinding(ref, boundObj, propertyName, method));
        }
    }

    public void add(ElementBinding binding) {
        this.bindings.add(binding);
    }

    public List<ElementBinding> getBindings() {
        return this.bindings;
    }

    static {
        bindingTypes.add(ValueBinding.bindingMaker);
        bindingTypes.add(ReferenceBinding.bindingMaker);
        bindingTypes.add(AttributesBinding.bindingMaker);
        bindingTypes.add(ValueAttributesBinding.bindingMaker);
    }
}

