/*
 * Decompiled with CFR 0.152.
 */
package bizrules.registry;

import bizrules.BusinessRule;
import bizrules.ElementProcessor;
import bizrules.binding.DocumentErrorBinding;
import bizrules.binding.DocumentEventBinding;
import bizrules.binding.DocumentEventListener;
import bizrules.binding.ElementBinding;
import bizrules.binding.ElementValueListener;
import bizrules.params.BizrulesParams;
import bizrules.registry.BusinessRuleRegistry;
import bizrules.registry.BusinessRuleRegistryAccess;
import bizrules.registry.DocumentEventDetail;
import bizrules.registry.EndElementDetail;
import bizrules.registry.ErrorHandlerRegistry;
import bizrules.registry.NamespaceHandler;
import bizrules.registry.NullEventDetail;
import bizrules.registry.StartElementDetail;
import com.gsl.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import processingError.ProcessingErrorCollector;
import xmldoc.Attribute;
import xmldoc.DocumentError;
import xmldoc.DocumentEventType;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import xmldoc.sax.XPathLocator;

public class BusinessRuleRegistryImpl
implements BusinessRuleRegistry,
BusinessRuleRegistryAccess {
    private final Logger logger = LoggerFactory.getLogger("bizrules.registry");
    private final Map<ElementReference, Collection<ElementBinding>> elementBindings = new HashMap<ElementReference, Collection<ElementBinding>>();
    private final ErrorHandlerRegistry errorHandlerRegistry = new ErrorHandlerRegistry();
    private final ProcessingErrorCollector errorCollector;
    private final List<NamespaceHandler> namespaceHandlers = new ArrayList<NamespaceHandler>();
    private final Map<String, Map<String, List<BusinessRule>>> ruleMaps = new HashMap<String, Map<String, List<BusinessRule>>>();
    private final Map<DocumentEventType, List<DocumentEventBinding>> eventBindings = new HashMap<DocumentEventType, List<DocumentEventBinding>>();
    private ElementReference currentElementReference;
    private final Stack<ElementReference> elementReferenceStack = new Stack();
    private boolean ignoreRulesFollowingDocumentErrors = false;
    private boolean invokeRules = true;
    private XPathLocator xPathLocator = null;
    private final Map<ElementReference, StringBuilder> elementValues = new HashMap<ElementReference, StringBuilder>();

    @Override
    public void registerNamespaceHandler(NamespaceHandler namespaceHandler) {
        this.namespaceHandlers.add(namespaceHandler);
    }

    public BusinessRuleRegistryImpl(ProcessingErrorCollector errorCollector, BizrulesParams params) {
        this.errorCollector = errorCollector;
        this.ignoreRulesFollowingDocumentErrors = params.getIgnoreBusinessRulesFollowingDocumentError();
        this.invokeRules = !params.getIgnoreBusinessRules();
    }

    @Override
    public void registerBusinessRule(BusinessRule rule) {
        this.initializeAttachmentPoints(rule);
        rule.setBusinessRuleRegistryAccess(this);
        this.registerElementProcessor(rule);
    }

    @Override
    public void registerElementProcessor(ElementProcessor processor) {
        this.initializeReferenceBindings(processor);
        this.initializeEventBindings(processor);
        this.initializeErrorBindings(processor);
        processor.setErrorCollector(this.errorCollector);
        processor.setXPathLocator(this.getXPathLocator());
        processor.postRegistrationSetup();
    }

    @Override
    public void registerValueBinding(ElementBinding binding) {
        this.addElementValueBinding(binding);
    }

    private void initializeErrorBindings(ElementProcessor processor) {
        List<DocumentErrorBinding> bindings = processor.getErrorBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            DocumentErrorBinding binding = bindings.get(i);
            this.errorHandlerRegistry.addErrorBinding(binding);
        }
    }

    private void initializeReferenceBindings(ElementValueListener listener) {
        List<ElementBinding> bindings = listener.getValueBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            ElementBinding binding = bindings.get(i);
            this.addElementValueBinding(binding);
        }
    }

    private void initializeEventBindings(DocumentEventListener listener) {
        List<DocumentEventBinding> bindings = listener.getEventBindings();
        for (int i = 0; i < bindings.size(); ++i) {
            DocumentEventBinding binding = bindings.get(i);
            this.addDocumentEventBinding(binding);
        }
    }

    private void addElementValueBinding(ElementBinding binding) {
        Collection<ElementBinding> bindings = this.elementBindings.get(binding.getReference());
        if (bindings == null) {
            bindings = new ArrayList<ElementBinding>();
            this.elementBindings.put(binding.getReference(), bindings);
        }
        bindings.add(binding);
    }

    @Override
    public void removeElementValueBinding(Object boundObject, ElementReference reference, String boundTo) {
        Collection<ElementBinding> bindings = this.lookupValueBindings(reference);
        if (bindings != null) {
            ArrayList<ElementBinding> toRemove = new ArrayList<ElementBinding>();
            for (ElementBinding binding : bindings) {
                if (binding.getBoundObject() != boundObject || !binding.getBoundProperty().equals(boundTo)) continue;
                toRemove.add(binding);
            }
            bindings.removeAll(toRemove);
        }
    }

    private void addDocumentEventBinding(DocumentEventBinding binding) {
        List<DocumentEventBinding> bindings = this.lookupEventBindings(binding.getEventType());
        if (bindings == null) {
            bindings = new ArrayList<DocumentEventBinding>();
            this.setDocumentEventBindings(binding, bindings);
        }
        bindings.add(binding);
    }

    @Override
    public void removeDocumentEventBinding(Object boundObject, ElementReference reference, String boundTo, DocumentEventType eventType) {
        DocumentEventBinding binding = new DocumentEventBinding(boundObject, reference, boundTo, eventType);
        this.removeDocumentEventBinding(binding);
    }

    private void removeDocumentEventBinding(DocumentEventBinding binding) {
        ArrayList<DocumentEventBinding> bindings = new ArrayList<DocumentEventBinding>(this.lookupEventBindings(binding.getEventType()));
        bindings.remove(binding);
        this.setDocumentEventBindings(binding, bindings);
        if (bindings.size() == 0) {
            this.eventBindings.remove(binding.getEventType());
        }
    }

    private void setDocumentEventBindings(DocumentEventBinding binding, List<DocumentEventBinding> bindings) {
        this.eventBindings.put(binding.getEventType(), bindings);
    }

    private void initializeAttachmentPoints(BusinessRule rule) {
        List<ElementReference> attachmentPoints = rule.getAttachmentPoints();
        for (int i = 0; i < attachmentPoints.size(); ++i) {
            ElementReference attachmentPoint = attachmentPoints.get(i);
            List<BusinessRule> ruleList = this.lookupRules(attachmentPoint);
            ruleList.add(rule);
        }
    }

    private void invokeRules(ElementReference elementRef) {
        if (this.invokeRules) {
            List<BusinessRule> rules = this.lookupRules(elementRef);
            for (int i = 0; i < rules.size(); ++i) {
                BusinessRule rule = rules.get(i);
                if (!rule.isActive()) continue;
                try {
                    rule.processRule();
                    continue;
                }
                catch (Error e) {
                    this.logger.severe("Caught error processing rule " + rule.getClass().getName());
                    throw e;
                }
            }
        }
    }

    private List<BusinessRule> lookupRules(ElementReference attachmentPoint) {
        Map<String, List<BusinessRule>> ruleMap = this.lookupRuleMap(attachmentPoint);
        List<BusinessRule> ruleList = ruleMap.get(attachmentPoint.getXPath());
        if (ruleList == null) {
            ruleList = new ArrayList<BusinessRule>();
            ruleMap.put(attachmentPoint.getXPath(), ruleList);
        }
        return ruleList;
    }

    private Map<String, List<BusinessRule>> lookupRuleMap(ElementReference attachmentPoint) {
        Map<String, List<BusinessRule>> ruleMap = this.ruleMaps.get(attachmentPoint.getNamespaceURL());
        if (ruleMap == null) {
            ruleMap = new HashMap<String, List<BusinessRule>>();
            this.ruleMaps.put(attachmentPoint.getNamespaceURL(), ruleMap);
        }
        return ruleMap;
    }

    private Collection<ElementBinding> lookupValueBindings(ElementReference elementRef) {
        return this.elementBindings.get(elementRef);
    }

    private List<DocumentEventBinding> lookupEventBindings(DocumentEventType eventType) {
        return this.eventBindings.get(eventType);
    }

    @Override
    public void startNamespace(String namespace) {
        for (NamespaceHandler namespaceHandler : this.namespaceHandlers) {
            namespaceHandler.handleNamespace(namespace);
        }
    }

    @Override
    public void endNamespace(String namespace) {
    }

    @Override
    public void startElement(ElementReference elementRef, Attribute[] attributes) {
        ElementReference parentElementReference = this.currentElementReference;
        this.elementReferenceStack.push(this.currentElementReference);
        this.currentElementReference = elementRef;
        Collection<ElementBinding> bindings = this.lookupValueBindings(elementRef);
        if (bindings != null) {
            for (ElementBinding binding : bindings) {
                binding.startElement(attributes);
            }
        }
        this.dispatchEvents(elementRef, DocumentEventType.startElement, new StartElementDetail(parentElementReference, elementRef, attributes));
    }

    @Override
    public void endElement(ElementReference elementRef) {
        Collection<ElementBinding> bindings = this.lookupValueBindings(elementRef);
        if (bindings != null) {
            StringBuilder b = this.elementValues.get(elementRef);
            String v = "";
            if (b != null) {
                v = b.toString();
                this.elementValues.remove(elementRef);
                b = null;
            }
            for (ElementBinding binding : bindings) {
                binding.setElementText(v);
                binding.endElement();
                binding.reset();
            }
        }
        this.dispatchEvents(elementRef, DocumentEventType.endElement, new EndElementDetail(elementRef));
        this.invokeRules(elementRef);
        this.currentElementReference = this.elementReferenceStack.pop();
    }

    private void dispatchEvents(ElementReference elementRef, DocumentEventType documentEventType, DocumentEventDetail eventDetail) {
        List<DocumentEventBinding> bindings = this.lookupEventBindings(documentEventType);
        if (bindings != null) {
            for (int i = 0; i < bindings.size(); ++i) {
                DocumentEventBinding binding = bindings.get(i);
                if (binding.getReference() != elementRef) continue;
                binding.invoke(eventDetail);
            }
        }
    }

    @Override
    public void elementText(ElementReference elementRef, char[] characters, int start, int length) {
        Collection<ElementBinding> bindings = this.lookupValueBindings(elementRef);
        if (bindings != null) {
            boolean wantsValue = false;
            for (ElementBinding binding : bindings) {
                if (!binding.wantsValue()) continue;
                wantsValue = true;
                break;
            }
            if (wantsValue) {
                StringBuilder b = this.elementValues.get(elementRef);
                if (b == null) {
                    b = new StringBuilder();
                    this.elementValues.put(elementRef, b);
                }
                b.append(characters, start, length);
            }
        }
    }

    @Override
    public void startDocument() {
        List<DocumentEventBinding> bindings = this.lookupEventBindings(DocumentEventType.startDocument);
        if (bindings != null) {
            for (int i = 0; i < bindings.size(); ++i) {
                DocumentEventBinding binding = bindings.get(i);
                binding.invoke(NullEventDetail.instance());
            }
        }
        this.startElement(SimpleElementReference.makeReference("/"), new Attribute[0]);
    }

    @Override
    public void endDocument() {
        this.endElement(SimpleElementReference.makeReference("/"));
        List<DocumentEventBinding> bindings = this.lookupEventBindings(DocumentEventType.endDocument);
        if (bindings != null) {
            for (int i = 0; i < bindings.size(); ++i) {
                DocumentEventBinding binding = bindings.get(i);
                binding.invoke(NullEventDetail.instance());
            }
        }
    }

    @Override
    public boolean handleError(DocumentError error) {
        List<DocumentErrorBinding> bindings = this.errorHandlerRegistry.lookupErrorBindings(error.getElementReference());
        assert (bindings != null);
        boolean errorHandledByRule = false;
        for (int i = 0; i < bindings.size() && !errorHandledByRule; ++i) {
            DocumentErrorBinding binding = bindings.get(i);
            errorHandledByRule = binding.invoke(error);
        }
        if (this.ignoreRulesFollowingDocumentErrors) {
            this.invokeRules = false;
        }
        return errorHandledByRule;
    }

    public boolean getIgnoreRulesFollowingDocumentErrors() {
        return this.ignoreRulesFollowingDocumentErrors;
    }

    public void setIgnoreRulesFollowingDocumentErrors(boolean ignoreRulesFollowingDocumentErrors) {
        this.ignoreRulesFollowingDocumentErrors = ignoreRulesFollowingDocumentErrors;
    }

    @Override
    public void setXPathLocator(XPathLocator locator) {
        this.xPathLocator = locator;
    }

    public XPathLocator getXPathLocator() {
        return this.xPathLocator;
    }
}

