/*
 * Decompiled with CFR 0.152.
 */
package bizrules.util;

import bizrules.BusinessRule;
import bizrules.params.BizrulesParams;
import com.gsl.logging.LoggerFactory;
import com.gsl.util.classlookup.CachingClassInstanceCollector;
import com.gsl.util.classlookup.ClassNameCollector;
import com.gsl.util.classlookup.CompositeInterfaceCollector;
import com.gsl.util.classlookup.InterfaceInstanceCollector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class BusinessRuleCollector {
    private static final Logger logger = LoggerFactory.getLogger("bizrules.setup");

    public static final List<BusinessRule> collectRules(String basePackageName, BizrulesParams params) {
        Class<BusinessRule> interfaceToCollect = BusinessRule.class;
        ClassNameCollector baseCollector = params.getForceDynamicClassCollection() ? new InterfaceInstanceCollector(basePackageName, interfaceToCollect) : new CompositeInterfaceCollector(basePackageName, interfaceToCollect);
        CachingClassInstanceCollector collector = new CachingClassInstanceCollector(baseCollector);
        Collection<Class<?>> classes = collector.collectClasses();
        if (classes.size() == 0) {
            logger.severe("No business rules were found in " + basePackageName);
        }
        ArrayList<BusinessRule> rules = new ArrayList<BusinessRule>(classes.size());
        Iterator<Class<?>> i$ = classes.iterator();
        while (i$.hasNext()) {
            Class<?> element;
            Class<?> ruleClass = element = i$.next();
            try {
                rules.add((BusinessRule)ruleClass.newInstance());
            }
            catch (InstantiationException e) {
                logger.warning("Could not instantiate rule class " + ruleClass.getName());
            }
            catch (IllegalAccessException e) {
                logger.warning("Could not access rule class " + ruleClass.getName());
            }
        }
        return rules;
    }
}

