/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.docValidator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import xmldoc.util.AbstractEntityResolver;
import xmldoc.util.EntityResolver;

public class CompositeEntityResolver
extends AbstractEntityResolver {
    private final List<EntityResolver> resolvers = new ArrayList<EntityResolver>();

    public void addResolver(EntityResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource resolvedInputSource = null;
        if (systemId == null) {
            this.getLogger().log(Level.SEVERE, "Null systemId is invalid (publicId = '" + publicId + "')");
        }
        Iterator<EntityResolver> iter = this.resolvers.iterator();
        while (resolvedInputSource == null && iter.hasNext()) {
            EntityResolver resolver = iter.next();
            resolvedInputSource = resolver.resolveEntity(publicId, systemId);
        }
        if (!(resolvedInputSource != null || systemId != null && systemId.endsWith(".dtd"))) {
            this.getLogger().warning("Could not resolve local entity for systemId = " + systemId);
        }
        return resolvedInputSource;
    }

    @Override
    public String getExternalSchemaLocations() {
        StringBuffer buf = new StringBuffer(512);
        for (EntityResolver resolver : this.resolvers) {
            buf.append(resolver.getExternalSchemaLocations());
        }
        return buf.toString();
    }
}

