/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.docValidator;

import bizrules.BusinessRule;
import bizrules.ElementProcessor;
import bizrules.registry.BusinessRuleRegistry;
import bizrules.registry.NamespaceHandler;
import bizrules.util.BusinessRuleCollector;
import com.gsl.docValidator.CompositeEntityResolver;
import com.gsl.docValidator.CurrentDate;
import com.gsl.docValidator.DocumentValidator;
import com.gsl.docValidator.DocumentValidatorController;
import com.gsl.docValidator.DocumentValidatorImplementor;
import com.gsl.docValidator.DocumentValidatorServices;
import com.gsl.docValidator.PostValidationDelegate;
import com.gsl.docValidator.ValidationException;
import com.gsl.docValidator.ValidationParams;
import com.gsl.docValidator.ValidationResultBean;
import com.gsl.docValidator.ValidationResultInterface;
import com.gsl.docValidator.ValidatorProvider;
import com.gsl.sax.xerces.XercesParserMaker;
import com.gsl.util.OneShotUseException;
import com.gsl.util.OneShotUseSupport;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import processingError.ErrorLimitExceeded;
import processingError.ProcessingError;
import xmldoc.DocumentErrorBean;
import xmldoc.sax.DocumentHandler;
import xmldoc.sax.TerminateParse;
import xmldoc.util.EntityResolver;

class DocumentValidatorImpl
extends OneShotUseSupport
implements DocumentValidatorController,
DocumentValidatorImplementor,
PostValidationDelegate,
NamespaceHandler {
    private final List<ValidatorProvider> providers = new ArrayList<ValidatorProvider>();
    private final List<EntityResolver> resolvers = new ArrayList<EntityResolver>();
    private ValidationParams params;
    private PostValidationDelegate delegate;
    private BusinessRuleRegistry ruleRegistry;
    private DocumentHandler docHandler;
    private boolean checkOneShotUse = true;

    DocumentValidatorImpl() {
    }

    @Override
    public void checkOneShotUse() throws OneShotUseException {
        super.checkOneShotUse();
        this.checkOneShotUse = false;
    }

    @Override
    protected String getOneShotUseExceptionMessage() {
        return "Validator instances can only be used once.  Please create a new validator instance for each document you want to validate.";
    }

    @Override
    public void addProvider(ValidatorProvider provider) {
        this.providers.add(provider);
    }

    @Override
    public void addResolver(EntityResolver resolver) {
        this.resolvers.add(resolver);
    }

    @Override
    public ValidationParams getParams() {
        return this.params;
    }

    @Override
    public PostValidationDelegate getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(PostValidationDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public void addBusinessRules(String basePackageName) {
        this.addBusinessRules(BusinessRuleCollector.collectRules(basePackageName, this.getParams().getBizruleParams()));
    }

    @Override
    public void addBusinessRules(List<BusinessRule> rules) {
        for (BusinessRule rule : rules) {
            this.addBusinessRule(rule);
        }
    }

    @Override
    public void addBusinessRule(BusinessRule rule) {
        this.ruleRegistry.registerBusinessRule(rule);
    }

    @Override
    public void addElementProcessor(ElementProcessor processor) {
        this.ruleRegistry.registerElementProcessor(processor);
    }

    @Override
    public ValidationResultInterface validate(DocumentValidator validator, Reader input, ValidationParams params, PostValidationDelegate delegate) throws ValidationException {
        return this.validate(validator, (Object)input, params, delegate);
    }

    @Override
    public ValidationResultInterface validate(DocumentValidator validator, InputStream input, ValidationParams params, PostValidationDelegate delegate) throws ValidationException {
        return this.validate(validator, (Object)input, params, delegate);
    }

    private ValidationResultInterface validate(DocumentValidator validator, Object input, ValidationParams params, PostValidationDelegate delegate) throws ValidationException {
        if (this.checkOneShotUse) {
            this.checkOneShotUse();
        }
        this.checkOneShotUse = true;
        try {
            long startTime = System.currentTimeMillis();
            if (params == null) {
                params = new ValidationParams(){};
            }
            CurrentDate.init(params.getCurrentDate());
            this.params = params;
            this.delegate = delegate;
            CompositeEntityResolver entityResolver = this.createEntityResolver();
            DocumentValidatorServices services = this.setupServices(validator, entityResolver);
            this.initProviders();
            this.parseDocument(params, entityResolver, services, input);
            this.destroyProviders();
            List<ProcessingError> processingErrors = services.getErrorCollector().getErrors();
            if (delegate == null) {
                delegate = this;
            }
            ValidationResultInterface result = delegate.createResult(processingErrors, params);
            result.setProcessingErrors(processingErrors);
            result.setProcessingTime(System.currentTimeMillis() - startTime);
            ValidationResultInterface validationResultInterface = result;
            return validationResultInterface;
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
        finally {
            this.params = null;
            this.delegate = null;
            this.ruleRegistry = null;
            this.docHandler = null;
            this.providers.clear();
            CurrentDate.destroy();
            validator.validationComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseDocument(ValidationParams params, CompositeEntityResolver entityResolver, DocumentValidatorServices services, Object input) throws IOException, SAXException {
        XMLReader parser = null;
        try {
            parser = this.createParser(params, entityResolver);
            InputSource inputSource = input instanceof Reader ? services.createInputSource((Reader)input) : services.createInputSource((InputStream)input);
            parser.parse(inputSource);
        }
        catch (ErrorLimitExceeded ele) {
            if (params.getReportErrorLimitExceeded()) {
                DocumentErrorBean error = new DocumentErrorBean(ele.getLastError().getLocation());
                error.setSubCode("5012");
                error.setSAXErrorMessage("More than " + ele.getMaxErrors() + " errors generated. Aborting document check.");
                services.getErrorCollector().getErrors().add(error);
            }
        }
        catch (TerminateParse tp) {
        }
        catch (SAXException e) {
            this.docHandler.endDocument();
        }
        finally {
            if (parser != null) {
                XercesParserMaker.release(parser);
            }
        }
    }

    private XMLReader createParser(ValidationParams params, CompositeEntityResolver entityResolver) throws SAXException {
        Object grammarPoolKey = params.getVariant();
        XMLReader parser = XercesParserMaker.makeParser(params.getParserParams(), entityResolver.getExternalSchemaLocations(), grammarPoolKey);
        parser.setContentHandler(this.docHandler);
        parser.setErrorHandler(this.docHandler);
        parser.setEntityResolver(this.docHandler);
        return parser;
    }

    private DocumentValidatorServices setupServices(DocumentValidator validator, CompositeEntityResolver entityResolver) {
        DocumentValidatorServices services = validator.createServices(this.params);
        this.ruleRegistry = services.getRuleRegistry();
        this.ruleRegistry.registerNamespaceHandler(this);
        this.docHandler = services.getDocumentHandler();
        this.docHandler.setEntityResolver(entityResolver);
        this.docHandler.setExceptionDecoder(services.getExceptionDecoder());
        this.docHandler.setNamespacePrefixMapper(services.getNamespacePrefixMapper());
        this.docHandler.setErrorCollector(services.getErrorCollector());
        return services;
    }

    boolean interrupt() {
        DocumentHandler docHandler = this.docHandler;
        if (docHandler != null) {
            docHandler.interrupt();
            return true;
        }
        return false;
    }

    private void initProviders() {
        for (ValidatorProvider provider : this.providers) {
            provider.init(this);
        }
    }

    private void destroyProviders() {
        for (ValidatorProvider provider : this.providers) {
            provider.destroy();
        }
    }

    private CompositeEntityResolver createEntityResolver() {
        CompositeEntityResolver compositeResolver = new CompositeEntityResolver();
        for (ValidatorProvider provider : this.providers) {
            EntityResolver resolver = provider.getEntityResolver(this.params);
            if (resolver == null) continue;
            compositeResolver.addResolver(resolver);
        }
        for (EntityResolver resolver : this.resolvers) {
            compositeResolver.addResolver(resolver);
        }
        return compositeResolver;
    }

    @Override
    public void handleNamespace(String namespace) {
        for (ValidatorProvider provider : this.providers) {
            provider.provisionNamespace(namespace, this);
        }
    }

    @Override
    public ValidationResultInterface createResult(List<ProcessingError> processingErrors, ValidationParams params) {
        return new ValidationResultBean();
    }
}

