/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.docValidator;

import bizrules.registry.BusinessRuleRegistry;
import bizrules.registry.BusinessRuleRegistryImpl;
import com.gsl.docValidator.ValidationParams;
import com.gsl.sax.decoder.xerces.erss.XercesExceptionDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.xml.sax.InputSource;
import processingError.ProcessingErrorCollector;
import processingError.SimpleErrorCollector;
import xmldoc.NamespacePrefixMapper;
import xmldoc.sax.DocumentHandler;
import xmldoc.sax.DocumentHandlerImpl;
import xmldoc.sax.SAXExceptionDecoder;

public class DocumentValidatorServices {
    private final ValidationParams params;
    private DocumentHandler docHandler;
    protected BusinessRuleRegistry ruleRegistry;
    private ProcessingErrorCollector errorCollector;
    private SAXExceptionDecoder exceptionDecoder;
    private NamespacePrefixMapper namespacePrefixMapper;

    public DocumentValidatorServices(ValidationParams params) {
        this.params = params;
    }

    protected ValidationParams params() {
        return this.params;
    }

    protected final DocumentHandler getDocumentHandler() {
        if (this.docHandler == null) {
            this.docHandler = this.createDocumentHandler();
        }
        return this.docHandler;
    }

    protected final BusinessRuleRegistry getRuleRegistry() {
        if (this.ruleRegistry == null) {
            this.ruleRegistry = this.createRuleRegistry();
        }
        return this.ruleRegistry;
    }

    protected final ProcessingErrorCollector getErrorCollector() {
        if (this.errorCollector == null) {
            this.errorCollector = this.createErrorCollector();
        }
        return this.errorCollector;
    }

    protected final SAXExceptionDecoder getExceptionDecoder() {
        if (this.exceptionDecoder == null) {
            this.exceptionDecoder = this.createExceptionDecoder();
        }
        return this.exceptionDecoder;
    }

    protected final NamespacePrefixMapper getNamespacePrefixMapper() {
        if (this.namespacePrefixMapper == null) {
            this.namespacePrefixMapper = this.createNamespacePrefixMapper();
        }
        return this.namespacePrefixMapper;
    }

    protected DocumentHandler createDocumentHandler() {
        return new DocumentHandlerImpl(this.getRuleRegistry());
    }

    protected BusinessRuleRegistry createRuleRegistry() {
        return new BusinessRuleRegistryImpl(this.getErrorCollector(), this.params.getBizruleParams());
    }

    protected ProcessingErrorCollector createErrorCollector() {
        SimpleErrorCollector collector = new SimpleErrorCollector();
        collector.setMaxErrors(this.params.getMaxErrors());
        return collector;
    }

    protected SAXExceptionDecoder createExceptionDecoder() {
        return new XercesExceptionDecoder();
    }

    protected NamespacePrefixMapper createNamespacePrefixMapper() {
        return null;
    }

    protected InputSource createInputSource(Reader input) throws IOException {
        return new InputSource(input);
    }

    protected InputSource createInputSource(InputStream input) throws IOException {
        return new InputSource(input);
    }
}

