/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.docValidator;

import bizrules.params.BizrulesParams;
import com.gsl.logging.LoggingParams;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import xmldoc.ParserParams;

public abstract class ValidationParams
implements Cloneable {
    private Map<Object, Object> parserFeatures = new HashMap<Object, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private LoggingParams loggingParams = new LoggingParams();
    private Date currentDate;
    private ParserParams parserParams = new ParserParams();
    private BizrulesParams bizruleParams = new BizrulesParams();
    private boolean includePrefixesInXPaths = true;
    private boolean outputDeveloperMessages = true;
    private boolean reportErrorLimitExceeded = true;
    private boolean suppressSchemaLocationHintErrors = false;
    private int maxErrors = 100000;

    public Object clone() throws CloneNotSupportedException {
        ValidationParams clone = (ValidationParams)super.clone();
        clone.loggingParams = (LoggingParams)this.loggingParams.clone();
        clone.parserParams = (ParserParams)this.parserParams.clone();
        clone.bizruleParams = (BizrulesParams)this.bizruleParams.clone();
        clone.parserFeatures = new HashMap<Object, Object>(this.parserFeatures);
        clone.attributes = new HashMap<String, Object>(this.attributes);
        return clone;
    }

    public String toString() {
        String s = "ValidationParams[";
        s = s + "currentDate=" + (this.currentDate != null ? this.currentDate.toString() : "now");
        s = s + ", ";
        s = s + "includePrefixesInXPaths=" + this.includePrefixesInXPaths;
        s = s + ", ";
        s = s + "outputDeveloperMessages=" + this.outputDeveloperMessages;
        s = s + ", ";
        s = s + "reportErrorLimitExceeded=" + this.reportErrorLimitExceeded;
        s = s + ", ";
        s = s + "maxErrors=" + this.maxErrors;
        s = s + ", ";
        s = s + "attributes=" + this.attributes;
        s = s + ", ";
        s = s + "parserFeatures=" + this.parserFeatures;
        s = s + ",\n";
        s = s + "loggingParams=" + this.loggingParams;
        s = s + ",\n";
        s = s + "parserParams=" + this.parserParams;
        s = s + ",\n";
        s = s + "bizruleParams=" + this.bizruleParams;
        s = s + "]";
        return s;
    }

    protected Object getVariant() {
        return this.getClass().getName();
    }

    public Map<Object, Object> getParserFeatures() {
        return this.parserFeatures;
    }

    public void addParserFeature(Object name, Object value) {
        this.parserFeatures.put(name, value);
    }

    @Deprecated
    public void setParserFeatures(Map<?, ?> parserFeatures) {
        this.parserFeatures = new HashMap(parserFeatures);
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public LoggingParams getLoggingParams() {
        return this.loggingParams;
    }

    public void setLoggingParams(LoggingParams loggingParams) {
        this.loggingParams = loggingParams;
    }

    public void setCurrentDate(Date currentDate) {
        this.currentDate = currentDate;
    }

    public Date getCurrentDate() {
        return this.currentDate;
    }

    public BizrulesParams getBizruleParams() {
        return this.bizruleParams;
    }

    public void setBizruleParams(BizrulesParams bizruleParams) {
        this.bizruleParams = bizruleParams;
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    public ParserParams getParserParams() {
        return this.parserParams;
    }

    public void setParserParams(ParserParams parserParams) {
        this.parserParams = parserParams;
    }

    public boolean getIncludePrefixesInXPaths() {
        return this.includePrefixesInXPaths;
    }

    public void setIncludePrefixesInXPaths(boolean includePrefixesInXPaths) {
        this.includePrefixesInXPaths = includePrefixesInXPaths;
    }

    public boolean getOutputDeveloperMessages() {
        return this.outputDeveloperMessages;
    }

    public void setOutputDeveloperMessages(boolean outputDeveloperMessages) {
        this.outputDeveloperMessages = outputDeveloperMessages;
    }

    public boolean getReportErrorLimitExceeded() {
        return this.reportErrorLimitExceeded;
    }

    public void setReportErrorLimitExceeded(boolean reportErrorLimitExceeded) {
        this.reportErrorLimitExceeded = reportErrorLimitExceeded;
    }

    public void setSuppressSchemaLocationHintErrors(boolean suppressSchemaLocationHintErrors) {
        this.suppressSchemaLocationHintErrors = suppressSchemaLocationHintErrors;
    }

    public boolean getSuppressSchemaLocationHintErrors() {
        return this.suppressSchemaLocationHintErrors;
    }
}

