/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.file;

import com.gsl.io.core.file.RegexFilenameFilter;
import com.gsl.io.core.stream.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

public class FileUtils {
    private static final Pattern nonZeroLengthStringPattern = Pattern.compile(".+");

    public static File createFileInstance(String filename) {
        File ret = new File(filename);
        if (!ret.exists()) {
            FileUtils.createParentDirectory(filename);
            ret = new File(filename);
        }
        return ret;
    }

    public static void createParentDirectory(String filename) {
        String[] dirs = filename.split(File.separator.equals("\\") ? "\\" + File.separator : File.separator);
        String dirName = "";
        for (int i = 0; i < dirs.length - 1; ++i) {
            if (new File(dirName = dirName + dirs[i] + File.separator).exists()) continue;
            new File(dirName).mkdir();
        }
    }

    public static void stitch(String[] filesToStitch, String finalName) throws IOException {
        FileWriter w = new FileWriter(finalName);
        for (String element : filesToStitch) {
            FileReader reader = new FileReader(element);
            char[] buffer = new char[1024];
            int charsRead = 0;
            while ((charsRead = reader.read(buffer)) > 0) {
                w.write(buffer, 0, charsRead);
            }
            reader.close();
        }
        w.close();
    }

    public static void zap(String[] filesToZap) {
        for (String element : filesToZap) {
            File f = new File(element);
            f.delete();
        }
    }

    public static boolean exists(String fileName) {
        File file = new File(fileName);
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File from, File to) throws IOException {
        if (to.isDirectory()) {
            to = new File(to, from.getName());
        }
        FileInputStream fis = new FileInputStream(from);
        try (FileOutputStream fos = new FileOutputStream(to);){
            byte[] bytes = StreamUtils.readAllBytesFromStream(fis);
            fos.write(bytes);
        }
    }

    public static void deleteAllFilesInDir(File dir) {
        FileUtils.deleteFilesInDir(dir, nonZeroLengthStringPattern);
    }

    public static void deleteFilesInDir(File dir, String filenamePattern) {
        FileUtils.deleteFilesInDir(dir, Pattern.compile(filenamePattern));
    }

    public static void deleteFilesInDir(File dir, Pattern filenamePattern) {
        if (dir.exists() && dir.isDirectory()) {
            File[] matchingFiles;
            for (File element : matchingFiles = dir.listFiles(new RegexFilenameFilter(filenamePattern))) {
                element.delete();
            }
        }
    }

    public static void deleteRecursivelyAllFilesInDir(File dir) {
        FileUtils.deleteRecursivelyFilesInDir(dir, nonZeroLengthStringPattern);
    }

    public static void deleteRecursivelyFilesInDir(File dir, String filenamePattern) {
        FileUtils.deleteRecursivelyFilesInDir(dir, Pattern.compile(filenamePattern));
    }

    public static void deleteRecursivelyFilesInDir(File dir, Pattern filenamePattern) {
        FileUtils.deleteFilesInDir(dir, filenamePattern);
        if (dir.exists() && dir.isDirectory()) {
            File[] children;
            for (File element : children = dir.listFiles()) {
                FileUtils.deleteRecursivelyFilesInDir(element, filenamePattern);
            }
        }
    }

    public static void clearDirectory(String directoryName) {
        File directory = new File(directoryName);
        FileUtils.clearDirectory(directory);
    }

    public static void clearDirectory(File file) {
        if (!file.exists()) {
            file.mkdirs();
        } else if (!file.isDirectory()) {
            System.out.println("Cannot clear directory " + file);
            System.exit(1);
        } else {
            File[] files;
            for (File f : files = file.listFiles()) {
                if (f.isDirectory()) {
                    FileUtils.clearDirectory(f);
                }
                f.delete();
            }
        }
    }

    public static byte[] readFileToBytes(File inputFile) throws FileNotFoundException, IOException {
        return FileUtils.readFileToString(inputFile).getBytes();
    }

    public static byte[] readSteamToBytes(InputStream is) throws IOException {
        return FileUtils.readStreamToString(is).getBytes();
    }

    public static String readFileToString(File inputFile) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(inputFile);
        return FileUtils.readStreamToString(fis);
    }

    public static String readStreamToString(InputStream fis) throws IOException {
        byte[] b = new byte[1024];
        String input = "";
        int count = -1;
        while ((count = fis.read(b)) >= 0) {
            input = input + new String(b, 0, count);
        }
        return input;
    }
}

