/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.file;

import com.gsl.io.core.stream.StreamUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;

public class JarBuilder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void buildJar(String entriesRootDirpath, String jarFilepath) throws IOException {
        File jarFile = new File(jarFilepath);
        if (jarFile.isDirectory()) {
            throw new IOException("JAR path \"" + jarFilepath + "\" points to a directory. It must denote a path to a file.");
        }
        if (!entriesRootDirpath.endsWith("/")) {
            entriesRootDirpath = entriesRootDirpath + "/";
        }
        File entryRootDir = new File(entriesRootDirpath);
        LinkedHashSet<File> entryFiles = new LinkedHashSet<File>();
        JarBuilder.collectJarEntries(entryRootDir, entryFiles);
        File jarFileDir = jarFile.getParentFile();
        if (jarFileDir != null && !jarFileDir.exists()) {
            jarFileDir.mkdirs();
        }
        Manifest manifest = new Manifest();
        try (JarOutputStream jos = new JarOutputStream((OutputStream)new FileOutputStream(jarFile), manifest);){
            for (File entryFile : entryFiles) {
                String entryFilepath = JarBuilder.makeEntryFilepath(entriesRootDirpath, entryFile);
                JarEntry entry = new JarEntry(entryFilepath);
                jos.putNextEntry(entry);
                if (!entryFile.isFile()) continue;
                try (FileInputStream is = new FileInputStream(entryFile);){
                    byte[] classFileBytes = StreamUtils.readAllBytesFromStream(is);
                    jos.write(classFileBytes);
                }
            }
        }
    }

    private static String makeEntryFilepath(String entriesRootDirpath, File entryFile) {
        StringBuffer buffer = new StringBuffer();
        String entryFilepath = entryFile.getAbsolutePath();
        if (entryFilepath.startsWith(entriesRootDirpath)) {
            buffer.append(entryFilepath.substring(entriesRootDirpath.length()));
        } else {
            buffer.append(entryFilepath);
        }
        if (entryFile.isDirectory() && !entryFilepath.endsWith(File.separator)) {
            buffer.append(File.separator);
        }
        return buffer.toString();
    }

    private static void collectJarEntries(File dir, Set<File> entryFiles) {
        if (dir.exists() && dir.isDirectory() && dir.canRead()) {
            File[] children;
            File[] filesFound;
            for (File entryFile : filesFound = dir.listFiles()) {
                entryFiles.add(entryFile);
            }
            for (File element : children = dir.listFiles()) {
                JarBuilder.collectJarEntries(element, entryFiles);
            }
        }
    }
}

