/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.file;

import com.gsl.io.core.file.AcceptAllFilenameFilter;
import com.gsl.io.core.file.FileProvider;
import com.gsl.io.core.file.RecursiveFileSelector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class RecursiveFileProvider
implements FileProvider {
    private final Set<File> selectedFiles;
    private final Iterator<File> selectedFileIterator;
    private static Logger logger = Logger.getLogger("io.core.file.RecursiveFileProvider");
    private long providedCount = 0L;

    public RecursiveFileProvider(String baseDirectoryName) {
        this(baseDirectoryName, new AcceptAllFilenameFilter());
    }

    public RecursiveFileProvider(String baseDirectoryName, FilenameFilter filter) {
        File baseDirectory = new File(baseDirectoryName);
        if (!baseDirectory.isDirectory()) {
            throw new IllegalArgumentException(baseDirectoryName + " is not a directory");
        }
        RecursiveFileSelector selector = new RecursiveFileSelector(filter);
        this.selectedFiles = selector.selectFiles(baseDirectory);
        this.selectedFileIterator = this.selectedFiles.iterator();
    }

    @Override
    public synchronized File getNextFile() {
        File result = null;
        if (this.selectedFileIterator.hasNext()) {
            ++this.providedCount;
            result = this.selectedFileIterator.next();
        } else if (this.providedCount != this.getFileCount()) {
            logger.warning("Total files provided: " + this.providedCount + ", should have been " + this.getFileCount());
        }
        return result;
    }

    @Override
    public long getFileCount() {
        return this.selectedFiles.size();
    }

    @Override
    public synchronized long getProvidedCount() {
        return this.providedCount;
    }
}

