/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.file;

import com.gsl.io.core.file.FileSelector;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Set;
import java.util.TreeSet;

public class RecursiveFileSelector
implements FileSelector {
    private final FilenameFilter filter;

    public RecursiveFileSelector(FilenameFilter filter) {
        this.filter = filter;
    }

    @Override
    public Set<File> selectFiles(File baseDir) {
        File[] files;
        if (!baseDir.isDirectory()) {
            throw new IllegalArgumentException(baseDir.getName() + " is not a directory");
        }
        TreeSet<File> result = new TreeSet<File>();
        for (File element : files = baseDir.listFiles()) {
            if (element.isDirectory()) {
                result.addAll(this.selectFiles(element));
                continue;
            }
            if (!element.isFile() || !this.filter.accept(baseDir, element.getName())) continue;
            result.add(element);
        }
        return result;
    }
}

