/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.file;

import com.gsl.io.core.file.AbstractIOFileFilter;
import java.io.File;
import java.util.Collection;

public class SuffixFileFilter
extends AbstractIOFileFilter {
    private final String[] suffixes;
    private final boolean caseInsensitive;

    public SuffixFileFilter(String suffix) {
        this(suffix, true);
    }

    public SuffixFileFilter(String suffix, boolean caseInsensitive) {
        if (suffix == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{suffix};
        this.caseInsensitive = caseInsensitive;
        if (caseInsensitive) {
            this.makeSuffixesLowerCase();
        }
    }

    public SuffixFileFilter(String[] suffixes) {
        this(suffixes, true);
    }

    public SuffixFileFilter(String[] suffixes, boolean caseInsensitive) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = suffixes;
        this.caseInsensitive = caseInsensitive;
        if (caseInsensitive) {
            this.makeSuffixesLowerCase();
        }
    }

    public SuffixFileFilter(Collection<String> suffixes) {
        this(suffixes, true);
    }

    public SuffixFileFilter(Collection<String> suffixes, boolean caseInsensitive) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The collection of suffixes must not be null");
        }
        this.suffixes = suffixes.toArray(new String[suffixes.size()]);
        this.caseInsensitive = caseInsensitive;
        if (caseInsensitive) {
            this.makeSuffixesLowerCase();
        }
    }

    private void makeSuffixesLowerCase() {
        for (int i = 0; i < this.suffixes.length; ++i) {
            this.suffixes[i] = this.suffixes[i].toLowerCase();
        }
    }

    @Override
    public boolean accept(File file) {
        String name = file.getName();
        if (this.caseInsensitive) {
            name = name.toLowerCase();
        }
        for (String element : this.suffixes) {
            if (!name.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean accept(File file, String name) {
        if (this.caseInsensitive) {
            name = name.toLowerCase();
        }
        for (String element : this.suffixes) {
            if (!name.endsWith(element)) continue;
            return true;
        }
        return false;
    }
}

