/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.reader;

import com.gsl.io.core.reader.ProgressReceiver;
import java.io.IOException;
import java.io.Reader;

public class ProgressReader
extends Reader {
    private final Reader underlyingReader;
    private long position = 0L;
    private final long length;
    private final ProgressReceiver callback;

    public ProgressReader(Reader underlyingReader, long length, ProgressReceiver callback) {
        this.underlyingReader = underlyingReader;
        this.length = length;
        this.callback = callback;
    }

    @Override
    public int read(char[] buf, int off, int len) throws IOException {
        int result = this.underlyingReader.read(buf, off, len);
        if (result != -1) {
            this.position += (long)result;
        }
        this.callback.setProgress(this.getProgress());
        return result;
    }

    public int getProgress() {
        int result = 100;
        if (this.length > 0L) {
            result = (int)(this.position % this.length * 100L / this.length);
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.underlyingReader.close();
    }
}

