/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.stream;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class StreamUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readAllBytesFromStream(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[is.available() + 1];
        int bytesReadCount = is.read(bytes);
        try {
            while (bytesReadCount != -1) {
                baos.write(bytes, 0, bytesReadCount);
                bytes = new byte[is.available() + 1];
                bytesReadCount = is.read(bytes);
            }
        }
        finally {
            is.close();
            baos.close();
        }
        byte[] allBytes = baos.toByteArray();
        return allBytes;
    }

    public static InputStream[] createByteEquivalentStreamCopies(InputStream is, int copyCount) throws IOException {
        byte[] allBytes = StreamUtils.readAllBytesFromStream(is);
        InputStream[] streamCopies = new InputStream[copyCount];
        for (int i = 0; i < copyCount; ++i) {
            ByteArrayInputStream streamCopy = new ByteArrayInputStream(allBytes);
            streamCopies[i] = streamCopy;
        }
        return streamCopies;
    }
}

