/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.io.core.stream;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public class WriterOutputStream
extends OutputStream {
    private final Writer writer;
    private final char[] buffer;

    public WriterOutputStream(Writer writer) {
        this(writer, 8192);
    }

    public WriterOutputStream(Writer writer, int bufferSize) {
        if (writer == null) {
            throw new IllegalArgumentException("Cannot instantiate WriteOutputStream with null");
        }
        this.buffer = new char[bufferSize];
        this.writer = writer;
    }

    @Override
    public void write(int charToWrite) throws IOException {
        this.writer.write(charToWrite);
    }

    public void dontwrite(byte[] bytes, int off, int len) throws IOException {
        int j = 0;
        int i = off;
        int lastByteToWrite = off + len;
        while (i < lastByteToWrite) {
            while (i < len && j < this.buffer.length) {
                this.buffer[j++] = (char)bytes[i];
                ++i;
            }
            this.writer.write(this.buffer, 0, len);
        }
    }

    public void dontwrite(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }
}

