/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.logging;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggerFactory {
    private static String scope = "default";
    private static Level defaultDefaultLevel = Level.INFO;
    private static Map<String, Level> levels = new HashMap<String, Level>();

    private LoggerFactory() {
    }

    public static Logger getLogger(String name) {
        Logger result = Logger.getLogger(LoggerFactory.getScopedName(name));
        result.setLevel(LoggerFactory.lookupLevel(name));
        return result;
    }

    private static String getScopedName(String name) {
        return LoggerFactory.getScope() + "." + name;
    }

    private static Level lookupLevel(String name) {
        Level result = null;
        String lookupString = name;
        boolean found = false;
        while (!found && !lookupString.equals("")) {
            Level level = levels.get(lookupString);
            if (level != null) {
                result = level;
                found = true;
                continue;
            }
            int dot = lookupString.lastIndexOf(46);
            if (dot > 0) {
                lookupString = lookupString.substring(0, dot);
                continue;
            }
            lookupString = "";
        }
        if (!found) {
            result = LoggerFactory.getDefaultLevel();
        }
        return result;
    }

    private static Level getDefaultLevel() {
        Level result = levels.get("default");
        if (result == null) {
            result = defaultDefaultLevel;
            levels.put("default", result);
        }
        return result;
    }

    public static String getScope() {
        return scope;
    }

    public static void setScope(String scope) {
        LoggerFactory.scope = scope;
    }

    public static Map<String, Level> getLevels() {
        return levels;
    }

    public static void setLevels(Map<String, Level> levels) {
        LoggerFactory.levels = levels;
    }
}

