/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces;

import com.gsl.sax.decoder.xerces.XercesErrorDecoder;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentErrorBean;
import xmldoc.DocumentLocation;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;
import xmldoc.sax.DocumentErrorPostProcessor;
import xmldoc.sax.NullErrorPostProcessor;

public abstract class AbstractXercesErrorDecoder
implements XercesErrorDecoder {
    private DocumentErrorPostProcessor errorPostProcessor = NullErrorPostProcessor.INSTANCE;

    protected DocumentErrorBean makeDocumentError(SAXParseException ex, ElementReference resultRef, String code, String valueInError) {
        DocumentLocation location = new DocumentLocation(ex, resultRef);
        DocumentErrorBean result = new DocumentErrorBean(location);
        result.setElementReference(resultRef);
        result.setUnderlyingError(ex);
        result.setErrorProcessor(this);
        result.setSubCode(code);
        result.setValueInError(valueInError);
        return result;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void setErrorPostProcessor(DocumentErrorPostProcessor postProcessor) {
        this.errorPostProcessor = postProcessor;
    }

    public DocumentErrorPostProcessor getErrorPostProcessor() {
        return this.errorPostProcessor;
    }

    protected ElementReference fixupElementReference(ElementReference elementRef, String errorText, String preceedingString, String terminatingString) {
        String xPath;
        String referenceElement;
        ElementReference result = elementRef;
        String elementName = this.extractString(errorText, preceedingString, terminatingString);
        if (elementName.contains(":")) {
            elementName = elementName.split(":")[1];
        }
        if (!(referenceElement = (xPath = elementRef.getXPath()).substring(xPath.lastIndexOf(47) + 1)).equals(elementName)) {
            result = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), elementRef.getXPath() + "/" + elementName);
        }
        return result;
    }

    protected String extractString(String text, String preceedingString, String terminatingString) {
        int substringStart = text.indexOf(preceedingString) + preceedingString.length();
        int substringEnd = text.indexOf(terminatingString, substringStart);
        String extractedString = text.substring(substringStart, substringEnd);
        return extractedString;
    }
}

