/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.chris;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.DocumentErrorBean;
import xmldoc.ElementReference;

public class CVCAttributeDecoder
extends AbstractXercesErrorDecoder {
    private final ErrorDecoderState state;

    public CVCAttributeDecoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-attribute.3:") || ex.getMessage().startsWith("cvc-complex-type.4:");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        String messageText = ex.getMessage();
        int attributeNameStart = messageText.toLowerCase().indexOf("attribute '") + 11;
        int attributeNameEnd = messageText.indexOf("'", attributeNameStart);
        String attributeName = messageText.substring(attributeNameStart, attributeNameEnd);
        DocumentError mostRecentError = this.state.getMostRecentError();
        String mostRecentCode = mostRecentError.getSubCode();
        if (mostRecentError.getElementReference().equals(elementRef) && (mostRecentCode.equals("cvc-pattern-valid") || mostRecentCode.equals("cvc-enumeration-valid"))) {
            mostRecentError.setAttributeName(attributeName);
            this.getErrorPostProcessor().scheduleErrorForProcessing(mostRecentError);
        }
        DocumentErrorBean result = this.makeDocumentError(ex, elementRef, "attribute", null);
        result.setAttributeName(attributeName);
        this.getErrorPostProcessor().scheduleErrorForProcessing(result);
        return result;
    }
}

