/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.chris;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.DocumentErrorBean;
import xmldoc.ElementReference;

public class CVCComplexType24aDecoder
extends AbstractXercesErrorDecoder {
    private static final String CVC_COMPLEX_TYPE_2_4_B = "cvc-complex-type.2.4.b";
    private static final String CVC_COMPLEX_TYPE_2_4_A = "cvc-complex-type.2.4.a";
    private final ErrorDecoderState state;

    public CVCComplexType24aDecoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith(CVC_COMPLEX_TYPE_2_4_A);
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        ElementReference resultRef = elementRef;
        DocumentError mostRecentError = this.state.getMostRecentError();
        boolean samePath = mostRecentError.getElementReference().getXPath().equals(elementRef.getXPath());
        if (mostRecentError.getSubCode().equals(CVC_COMPLEX_TYPE_2_4_B) && samePath) {
            this.getErrorPostProcessor().scheduleErrorForProcessing(mostRecentError);
        }
        DocumentErrorBean result = this.makeDocumentError(ex, resultRef, CVC_COMPLEX_TYPE_2_4_A, null);
        this.getErrorPostProcessor().scheduleErrorForProcessing(result);
        return result;
    }
}

