/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.chris;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.DocumentErrorBean;
import xmldoc.ElementReference;

public class CVCType313Decoder
extends AbstractXercesErrorDecoder {
    public static final String CVC_TYPE_3_1_3 = "cvc-type.3.1.3";
    private final Pattern pattern = Pattern.compile("cvc-type.3.1.3: The value '(.*)' of element '(.*:)?(.+)' is not valid.");
    private final ErrorDecoderState state;

    public CVCType313Decoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-type.3.1.3:");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        DocumentErrorBean result;
        Matcher matcher = this.pattern.matcher(ex.getMessage());
        if (matcher.matches()) {
            String value = matcher.group(1);
            String elementName = matcher.group(3);
            DocumentError mostRecentError = this.state.getMostRecentError();
            result = this.makeDocumentError(ex, elementRef, CVC_TYPE_3_1_3, value);
            if (!mostRecentError.getElementReference().getXPath().endsWith(elementName)) {
                this.getErrorPostProcessor().scheduleErrorForProcessing(mostRecentError);
            }
            if (!elementRef.getXPath().endsWith(elementName)) {
                this.getErrorPostProcessor().scheduleErrorForProcessing(result);
            }
        } else {
            result = this.makeDocumentError(ex, elementRef, CVC_TYPE_3_1_3, null);
        }
        return result;
    }
}

