/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.chris;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import com.gsl.sax.decoder.xerces.XercesErrorDecoder;
import com.gsl.sax.decoder.xerces.chris.CVCAttributeDecoder;
import com.gsl.sax.decoder.xerces.chris.CVCComplexType22Decoder;
import com.gsl.sax.decoder.xerces.chris.CVCComplexType24aDecoder;
import com.gsl.sax.decoder.xerces.chris.CVCComplexType24dDecoder;
import com.gsl.sax.decoder.xerces.chris.CVCComplexType322Decoder;
import com.gsl.sax.decoder.xerces.chris.CVCPatternValidDecoder;
import com.gsl.sax.decoder.xerces.chris.CVCType313Decoder;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import processingError.ProcessingError;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.AbstractSAXExceptionDecoder;
import xmldoc.sax.DocumentErrorPostProcessor;

public class ChRISXercesExceptionDecoder
extends AbstractSAXExceptionDecoder {
    private List<AbstractXercesErrorDecoder> decoders;
    private final ErrorDecoderState state = new ErrorDecoderState();
    private DocumentErrorPostProcessor errorPostProcessor = null;

    public ChRISXercesExceptionDecoder() {
        this.initializeDecoders();
    }

    @Override
    public DocumentError decodeException(ElementReference elementRef, SAXParseException ex) {
        String string;
        ProcessingError result = null;
        for (XercesErrorDecoder xercesErrorDecoder : this.decoders) {
            if (!xercesErrorDecoder.canDecode(ex)) continue;
            result = xercesErrorDecoder.decodeError(ex, elementRef);
            break;
        }
        String message = ex.getMessage();
        if (result == null) {
            int n = message.indexOf(":");
            if (n > 0) {
                String errorCode = message.substring(0, n);
                result = this.makeDocumentError(ex, elementRef, errorCode, null);
            } else {
                result = this.makeDocumentError(ex, elementRef, message, null);
            }
        }
        if (!(string = result.getSubCode()).equals("suppress") && !string.equals("unknown")) {
            this.getState().setMostRecentError((DocumentError)result);
        }
        if (result != null) {
            result.setSAXErrorMessage(message);
        }
        return result;
    }

    private ErrorDecoderState getState() {
        return this.state;
    }

    private void initializeDecoders() {
        this.decoders = new ArrayList<AbstractXercesErrorDecoder>(20);
        this.decoders.add(new CVCType313Decoder(this.getState()));
        this.decoders.add(new CVCAttributeDecoder(this.getState()));
        this.decoders.add(new CVCComplexType322Decoder());
        this.decoders.add(new CVCComplexType24aDecoder(this.getState()));
        this.decoders.add(new CVCComplexType24dDecoder(this.getState()));
        this.decoders.add(new CVCPatternValidDecoder());
        this.decoders.add(new CVCComplexType22Decoder());
    }

    @Override
    public void setDocumentErrorPostProcessor(DocumentErrorPostProcessor postProcessor) {
        this.errorPostProcessor = postProcessor;
        for (int i = 0; i < this.decoders.size(); ++i) {
            XercesErrorDecoder decoder = this.decoders.get(i);
            decoder.setErrorPostProcessor(this.errorPostProcessor);
        }
    }
}

