/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import java.util.regex.Pattern;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.ElementReference;

public class BadEntityReferenceDecoder
extends AbstractXercesErrorDecoder {
    private static final Pattern PATTERN_NOT_DELIMITED = Pattern.compile("The reference to entity \".+\" must end with the ';' delimiter\\.");
    private static final Pattern PATTERN_NOT_DECLARED = Pattern.compile("The entity \".+\" was referenced, but not declared\\.");

    @Override
    public boolean canDecode(SAXParseException ex) {
        return PATTERN_NOT_DELIMITED.matcher(ex.getMessage()).matches() || PATTERN_NOT_DECLARED.matcher(ex.getMessage()).matches();
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        return this.makeDocumentError(ex, elementRef, "format", null);
    }
}

