/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class CVCAttributeDecoder
extends AbstractXercesErrorDecoder {
    private final ErrorDecoderState state;

    public CVCAttributeDecoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-attribute.3:") || ex.getMessage().startsWith("cvc-complex-type.4:");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        String messageText = ex.getMessage();
        ElementReference resultRef = this.fixupElementReference(elementRef, messageText, "element '", "'");
        int attributeNameStart = messageText.toLowerCase().indexOf("attribute '") + 11;
        int attributeNameEnd = messageText.indexOf("'", attributeNameStart);
        String attributeName = messageText.substring(attributeNameStart, attributeNameEnd);
        String attributeXpath = resultRef.getXPath() + "/@" + attributeName;
        resultRef = SimpleElementReference.makeReference(resultRef.getNamespaceURL(), attributeXpath);
        DocumentError mostRecentError = this.state.getMostRecentError();
        String mostRecentCode = mostRecentError.getSubCode();
        if (mostRecentError.getElementReference().equals(elementRef) && (mostRecentCode.equals("blank") || mostRecentCode.equals("format") || mostRecentCode.equals("value"))) {
            mostRecentError.setSubCode("suppress");
        }
        return this.makeDocumentError(ex, resultRef, "attribute", null);
    }
}

