/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.ElementReference;

public class CVCComplexType22Decoder
extends AbstractXercesErrorDecoder {
    private final ErrorDecoderState state;

    public CVCComplexType22Decoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.2");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        ElementReference mostRecentRef;
        String errorText = ex.getMessage();
        String code = "unknown";
        ElementReference resultRef = this.fixupElementReference(elementRef, errorText, "Element '", "'");
        if (resultRef.equals(mostRecentRef = this.state.getMostRecentError().getElementReference())) {
            code = "suppress";
        } else {
            String mostRecentCode = this.state.getMostRecentError().getSubCode();
            if (elementRef.equals(mostRecentRef) && mostRecentCode.equals("blank")) {
                code = "blank";
                this.state.getMostRecentError().setSubCode("suppress");
            } else {
                code = "format";
            }
        }
        return this.makeDocumentError(ex, resultRef, code, null);
    }
}

