/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class CVCComplexType24aDecoder
extends AbstractXercesErrorDecoder {
    private final ErrorDecoderState state;

    public CVCComplexType24aDecoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.4.a");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        String errorText = ex.getMessage();
        ElementReference resultRef = elementRef;
        String code = "unknown";
        DocumentError mostRecentError = this.state.getMostRecentError();
        String message = mostRecentError.getMessage();
        if (message.startsWith("cvc-complex-type.2.4.b") && mostRecentError.getSubCode().equals("mandatory")) {
            code = "suppress";
            this.state.reset();
            return this.makeDocumentError(ex, resultRef, code, null);
        }
        String expectedListString = errorText.substring(errorText.indexOf(123), errorText.indexOf(125));
        String[] expectedList = expectedListString.split(",");
        if (expectedList.length == 1) {
            String expectedElement = expectedList[0].substring(expectedList[0].indexOf("\":") + 2);
            resultRef = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), elementRef.getXPath() + "/" + expectedElement);
            code = "mandatory";
        } else if (expectedList.length > 1) {
            int elementNameStart = errorText.indexOf("element '") + "element '".length();
            int elementNameEnd = errorText.indexOf("'", elementNameStart);
            String invalidElementName = errorText.substring(elementNameStart, elementNameEnd);
            resultRef = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), elementRef.getXPath() + "/" + invalidElementName);
            code = "invalid";
        }
        return this.makeDocumentError(ex, resultRef, code, null);
    }
}

