/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.SimpleElementReference;

public class CVCComplexType24bDecoder
extends AbstractXercesErrorDecoder {
    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-complex-type.2.4.b");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        String errorText = ex.getMessage();
        ElementReference resultRef = elementRef;
        String code = "unknown";
        String expectedListString = errorText.substring(errorText.indexOf(123), errorText.indexOf(125));
        String[] expectedList = expectedListString.split(",");
        if (expectedList.length == 1) {
            String expectedElement = expectedList[0].substring(expectedList[0].indexOf("\":") + 2);
            String resultXPath = this.fixupXPath(elementRef, errorText, expectedElement);
            resultRef = SimpleElementReference.makeReference(elementRef.getNamespaceURL(), resultXPath);
            code = "mandatory";
        } else {
            code = "invalid";
        }
        return this.makeDocumentError(ex, resultRef, code, null);
    }

    private String fixupXPath(ElementReference elementRef, String errorText, String expectedElement) {
        String resultXpath = elementRef.getXPath();
        String intermediateTag = this.extractIntermediateTag(errorText);
        if (!resultXpath.endsWith("/" + intermediateTag)) {
            resultXpath = resultXpath + "/" + intermediateTag;
        }
        resultXpath = resultXpath + "/" + expectedElement;
        return resultXpath;
    }

    private String extractIntermediateTag(String errorText) {
        int intermediateTagStart = errorText.indexOf(39) + 1;
        int intermediateTagEnd = errorText.indexOf(39, intermediateTagStart);
        String intermediateTag = errorText.substring(intermediateTagStart, intermediateTagEnd);
        return intermediateTag;
    }
}

