/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import org.xml.sax.SAXParseException;
import xmldoc.DocumentError;
import xmldoc.DocumentErrorBean;
import xmldoc.ElementReference;

public class CVCType313Decoder
extends AbstractXercesErrorDecoder {
    private final ErrorDecoderState state;

    public CVCType313Decoder(ErrorDecoderState state) {
        this.state = state;
    }

    @Override
    public boolean canDecode(SAXParseException ex) {
        return ex.getMessage().startsWith("cvc-type.3.1.3:");
    }

    @Override
    public DocumentError decodeError(SAXParseException ex, ElementReference elementRef) {
        String errorText = ex.getMessage();
        ElementReference newRef = this.fixupElementReference(elementRef, errorText, "element '", "'");
        String code = "unknown";
        DocumentError mostRecentError = this.state.getMostRecentError();
        if (mostRecentError.getElementReference().equals(newRef)) {
            code = "suppress";
        } else {
            if (mostRecentError.getElementReference().equals(elementRef)) {
                mostRecentError.setSubCode("suppress");
            }
            int valueStart = errorText.indexOf("value '") + 7;
            int valueEnd = errorText.indexOf(39, valueStart);
            String value = errorText.substring(valueStart, valueEnd);
            code = "suppress";
            if (value.equals("") && (errorText.length() <= valueEnd + 1 || !errorText.substring(valueEnd + 1, valueEnd + 2).equals("'"))) {
                code = "blank";
            }
        }
        DocumentErrorBean result = this.makeDocumentError(ex, newRef, code, "");
        return result;
    }
}

