/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.decoder.xerces.erss;

import com.gsl.sax.decoder.xerces.AbstractXercesErrorDecoder;
import com.gsl.sax.decoder.xerces.ErrorDecoderState;
import com.gsl.sax.decoder.xerces.XercesErrorDecoder;
import com.gsl.sax.decoder.xerces.erss.BadEntityReferenceDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCAttributeDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCBadFormatDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCComplexType22Decoder;
import com.gsl.sax.decoder.xerces.erss.CVCComplexType24aDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCComplexType24bDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCComplexType322Decoder;
import com.gsl.sax.decoder.xerces.erss.CVCDataTypeValidDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCEnumerationValidDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCMaxInclusiveDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCMinInclusiveDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCMinLengthDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCPatternValidDecoder;
import com.gsl.sax.decoder.xerces.erss.CVCType311Decoder;
import com.gsl.sax.decoder.xerces.erss.CVCType313Decoder;
import com.gsl.sax.decoder.xerces.erss.WellFormedTextOrMarkupDecoder;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.SAXParseException;
import processingError.ProcessingError;
import xmldoc.DocumentError;
import xmldoc.ElementReference;
import xmldoc.sax.AbstractSAXExceptionDecoder;
import xmldoc.sax.DocumentErrorPostProcessor;
import xmldoc.sax.XPathLocationStack;

public class XercesExceptionDecoder
extends AbstractSAXExceptionDecoder {
    private List<AbstractXercesErrorDecoder> decoders;
    private final ErrorDecoderState state = new ErrorDecoderState();

    public XercesExceptionDecoder() {
        this.initializeDecoders();
    }

    @Override
    public DocumentError decodeException(ElementReference elementRef, SAXParseException ex) {
        String resultCode;
        ProcessingError result = null;
        for (XercesErrorDecoder xercesErrorDecoder : this.decoders) {
            if (!xercesErrorDecoder.canDecode(ex)) continue;
            result = xercesErrorDecoder.decodeError(ex, elementRef);
            break;
        }
        if (result == null) {
            result = this.makeDocumentError(ex, elementRef, "unknown", null);
        }
        if (!(resultCode = result.getSubCode()).equals("suppress") && !resultCode.equals("unknown")) {
            this.getState().setMostRecentError((DocumentError)result);
        }
        if (result != null) {
            result.setSAXErrorMessage(ex.getMessage());
        }
        return result;
    }

    private ErrorDecoderState getState() {
        return this.state;
    }

    private void initializeDecoders() {
        this.decoders = new ArrayList<AbstractXercesErrorDecoder>(20);
        this.decoders.add(new CVCType313Decoder(this.getState()));
        this.decoders.add(new CVCType311Decoder());
        this.decoders.add(new CVCPatternValidDecoder());
        this.decoders.add(new CVCBadFormatDecoder());
        this.decoders.add(new CVCEnumerationValidDecoder());
        this.decoders.add(new CVCComplexType24aDecoder(this.getState()));
        this.decoders.add(new CVCComplexType24bDecoder());
        this.decoders.add(new CVCComplexType22Decoder(this.getState()));
        this.decoders.add(new CVCMinInclusiveDecoder());
        this.decoders.add(new CVCMaxInclusiveDecoder());
        this.decoders.add(new CVCDataTypeValidDecoder());
        this.decoders.add(new CVCAttributeDecoder(this.getState()));
        this.decoders.add(new CVCComplexType322Decoder());
        this.decoders.add(new CVCMinLengthDecoder());
        this.decoders.add(new WellFormedTextOrMarkupDecoder());
        this.decoders.add(new BadEntityReferenceDecoder());
    }

    public DocumentError decodeException(ElementReference currentElementRef, XPathLocationStack locationStack, SAXParseException ex) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    public void setDocumentErrorPostProcessor(DocumentErrorPostProcessor ruleRegistry) {
    }
}

