/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.xerces;

import com.gsl.logging.LoggerFactory;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderPool {
    private static final Logger logger = LoggerFactory.getLogger(XMLReaderPool.class.getName());
    private final LinkedList<XMLReader> pool = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLReader get() throws SAXException {
        XMLReader reader = null;
        LinkedList<XMLReader> linkedList = this.pool;
        synchronized (linkedList) {
            reader = this.pool.isEmpty() ? this.createReader(reader) : this.pool.removeLast();
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(XMLReader reader) {
        if (reader != null) {
            LinkedList<XMLReader> linkedList = this.pool;
            synchronized (linkedList) {
                this.pool.addFirst(reader);
            }
        } else {
            logger.warning("attempt to release null parser, ignoring");
        }
    }

    private XMLReader createReader(XMLReader reader) throws SAXException {
        try {
            reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        catch (SAXException e) {
            logger.severe("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
            e.printStackTrace();
            throw e;
        }
        return reader;
    }
}

