/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.xerces;

import com.gsl.sax.xerces.XercesParserMaker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import xmldoc.ParserParams;
import xmldoc.util.ClasspathEntityResolver;

public class XSDIntrospector {
    private static final ParserParams parserParams = new ParserParams();
    private String targetNamespace;

    public XSDIntrospector(File file) {
        this(XSDIntrospector.createFileInputStream(file));
    }

    private static FileInputStream createFileInputStream(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDIntrospector(InputStream in) {
        try {
            XMLReader parser = XercesParserMaker.makeParser(parserParams);
            try {
                SAXHandler saxHandler = new SAXHandler();
                parser.setContentHandler(saxHandler);
                parser.setErrorHandler(saxHandler);
                parser.setEntityResolver(saxHandler);
                parser.parse(new InputSource(new InputStreamReader(in, Charset.forName("UTF-8"))));
            }
            finally {
                XercesParserMaker.release(parser);
            }
        }
        catch (SAXException done) {
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    static {
        parserParams.setDoSchemaValidation(false);
    }

    private class SAXHandler
    extends DefaultHandler {
        final String NAMESPACE_XML = "http://www.w3.org/XML/1998/namespace";
        final String[][] ENTITY_RESOLUTION_TABLE = new String[][]{{"http://www.w3.org/XML/1998/namespace", "/xml.xsd"}, {"http://www.w3.org/2001/XMLSchema.dtd", "/XMLSchema.dtd"}, {"/datatypes.dtd", "/datatypes.dtd"}, {"http://www.w3.org/2001/datatypes.dtd", "/datatypes.dtd"}};
        private final ClasspathEntityResolver entityResolver = new ClasspathEntityResolver(this.ENTITY_RESOLUTION_TABLE);

        private SAXHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String name, String qName, Attributes attributes) throws SAXException {
            if ("schema".equals(name)) {
                XSDIntrospector.this.targetNamespace = attributes.getValue("targetNamespace");
                throw new SAXException("done");
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
            InputSource is;
            if (systemId.startsWith("file://")) {
                systemId = systemId.substring(systemId.lastIndexOf("/"));
            }
            if ((is = this.entityResolver.resolveEntity(publicId, systemId)) == null) {
                try {
                    is = super.resolveEntity(publicId, systemId);
                }
                catch (SAXException saxException) {
                    throw saxException;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            if (is != null) {
                is.setSystemId(systemId);
            }
            return is;
        }
    }
}

