/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.sax.xerces;

import com.gsl.logging.LoggerFactory;
import com.gsl.sax.xerces.DefaultXercesFeatureset;
import com.gsl.sax.xerces.XMLGrammarPoolMap;
import com.gsl.sax.xerces.XMLGrammarPoolMapImpl;
import com.gsl.sax.xerces.XMLReaderPool;
import java.util.HashMap;
import java.util.logging.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import xmldoc.ParserParams;

public class XercesParserMaker
implements DefaultXercesFeatureset {
    private static final Logger log = LoggerFactory.getLogger(XercesParserMaker.class.getName());
    private static XMLReaderPool readerPool = new XMLReaderPool();
    public static final String NAMESPACE_PREFIXES_PROPERTY = "namespacePrefixes";
    private static final String VALIDATION_PROPERTY = "validation";
    private static final String SCHEMA_VALIDATION_PROPERTY = "schemaValidation";
    private static final XMLGrammarPoolMap GRAMMAR_POOL_MAP = new XMLGrammarPoolMapImpl();

    public static XMLReader makeParser(ParserParams parserParams) throws SAXException {
        return XercesParserMaker.makeParser(parserParams, "", null);
    }

    public static XMLReader makeParser(ParserParams parserParams, String[][] entityResolutionTable, Object grammarPoolKey) throws SAXException {
        return XercesParserMaker.makeParser(parserParams, XercesParserMaker.prepareSchemaLocations(entityResolutionTable), grammarPoolKey);
    }

    public static void flushGrammarPool(Object grammarPoolKey) {
        GRAMMAR_POOL_MAP.flush(grammarPoolKey);
    }

    public static XMLReader makeParser(ParserParams parserParams, String externalSchemaLocations, Object grammarPoolKey) throws SAXException {
        XMLReader parser = readerPool.get();
        HashMap<String, Boolean> parserFeatures = null;
        if (!parserParams.getDoSchemaValidation()) {
            parserFeatures = new HashMap<String, Boolean>();
            parserFeatures.put(VALIDATION_PROPERTY, Boolean.FALSE);
            parserFeatures.put(SCHEMA_VALIDATION_PROPERTY, Boolean.FALSE);
        }
        boolean namespaces = true;
        boolean namespacePrefixes = true;
        boolean validation = true;
        boolean schemaValidation = true;
        boolean schemaFullChecking = false;
        boolean dynamicValidation = false;
        if (parserFeatures != null) {
            Boolean suppliedSchemaValidation;
            Boolean suppliedValidation;
            Boolean suppliedNamespacePrefixes = (Boolean)parserFeatures.get(NAMESPACE_PREFIXES_PROPERTY);
            if (suppliedNamespacePrefixes != null) {
                namespacePrefixes = suppliedNamespacePrefixes;
            }
            if ((suppliedValidation = (Boolean)parserFeatures.get(VALIDATION_PROPERTY)) != null) {
                validation = suppliedValidation;
            }
            if ((suppliedSchemaValidation = (Boolean)parserFeatures.get(SCHEMA_VALIDATION_PROPERTY)) != null) {
                schemaValidation = suppliedSchemaValidation;
            }
        }
        try {
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", externalSchemaLocations);
        }
        catch (SAXException e) {
            log.warning("Parser does not support property (http://apache.org/xml/properties/schema/external-schemaLocation)");
        }
        try {
            parser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", GRAMMAR_POOL_MAP.getXMLGrammarPool(grammarPoolKey));
        }
        catch (SAXException e) {
            log.warning("Parser does not support property (http://apache.org/xml/properties/internal/grammar-pool)");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (SAXException e) {
            log.warning("Parser does not support feature (http://xml.org/sax/features/namespaces)");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", namespacePrefixes);
        }
        catch (SAXException e) {
            log.warning("Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/validation", validation);
        }
        catch (SAXException e) {
            log.warning("Parser does not support feature (http://xml.org/sax/features/validation)");
        }
        try {
            parser.setFeature("http://apache.org/xml/features/validation/schema", schemaValidation);
        }
        catch (SAXNotRecognizedException e) {
            log.warning("Parser does not support feature (http://apache.org/xml/features/validation/schema)");
        }
        catch (SAXNotSupportedException e) {
            log.warning("Parser does not support feature (http://apache.org/xml/features/validation/schema)");
        }
        try {
            parser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
        }
        catch (SAXNotRecognizedException e) {
            log.warning("Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
        }
        catch (SAXNotSupportedException e) {
            log.warning("Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
        }
        try {
            parser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
        }
        catch (SAXNotRecognizedException e) {
            log.warning("Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
        }
        catch (SAXNotSupportedException e) {
            log.warning("Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
        }
        return parser;
    }

    public static void release(XMLReader parser) {
        readerPool.release(parser);
    }

    private static String prepareSchemaLocations(String[][] entityResolutionTable) {
        String[] schemas = new String[entityResolutionTable.length];
        for (int i = 0; i < entityResolutionTable.length; ++i) {
            String[] entry = entityResolutionTable[i];
            schemas[i] = entry[0];
        }
        String externalSchemaLocations = "";
        for (String element : schemas) {
            externalSchemaLocations = externalSchemaLocations + element + " " + element + " ";
        }
        return externalSchemaLocations;
    }
}

