/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron;

import com.gsl.io.core.file.JarBuilder;
import com.gsl.schematron.SchematronCompilerArgParseException;
import com.gsl.schematron.SchematronCompilerArgParser;
import com.gsl.schematron.validator.api.SchematronValidatorFactories;
import com.gsl.schematron.validator.api.SchematronValidatorParams;
import java.io.File;
import java.io.IOException;

public class SchematronCompiler {
    public static void main(String ... args) {
        SchematronCompilerArgParser parser = null;
        try {
            parser = new SchematronCompilerArgParser(args);
        }
        catch (SchematronCompilerArgParseException scapEx) {
            System.out.println("Error:  " + scapEx.getMessage());
            SchematronCompiler.displayUsage();
            System.exit(0);
        }
        new SchematronCompiler().compile(parser);
        if (parser.isJarRequested()) {
            System.out.println("Building JAR...");
            try {
                JarBuilder.buildJar(parser.getOutputDirpath(), parser.getJarFilepath());
            }
            catch (IOException ioEx) {
                System.out.println("Error:  JAR file could not be built:  " + ioEx.getMessage());
            }
        }
        System.out.println("Complete.");
    }

    private static void displayUsage() {
        System.out.println();
        System.out.println("Usage:  " + SchematronCompiler.class.getName() + " -a <artefact-dir> [-o <output-dir> [-jar <jar-filepath>]] [-source <source-dir>]");
        System.out.println("where:");
        System.out.println("    -a <artefact-dir>:");
        System.out.println("        Is the directory path containing rule artefacts.");
        System.out.println("    -o <output-dir> (optional):");
        System.out.println("        Is the directory path where compiled rule classes will be written.");
        System.out.println("        If not specified, classes will be written to a temporary directory unless the -source flag is specified.");
        System.out.println("        If the -source flag is specified and the -o flag it omitted then no classes will be compiled.");
        System.out.println("    -source <source-dir> (optional):");
        System.out.println("        Is the directory path where generated rule sources will be written.");
        System.out.println("        If not specified, sources will not be written to a directory.");
        System.out.println("    -jar <jar-filepath> (optional):");
        System.out.println("        Builds a JAR file containing all compiled rule classes at the specified path (including filename).");
        System.out.println();
        switch (File.separatorChar) {
            case '/': {
                System.out.println("Example:  " + SchematronCompiler.class.getName() + " ~/mov/artefacts ~/mov/output -source ~/mov/source -jar ~/mov/mov.jar");
                break;
            }
            case '\\': {
                System.out.println("Example:  " + SchematronCompiler.class.getName() + " C:\\mov\\artefacts C:\\mov\\output -source C:\\mov\\source -jar C:\\mov\\mov.jar");
                break;
            }
        }
    }

    public void compile(SchematronCompilerArgParser parser) {
        SchematronValidatorParams params = new SchematronValidatorParams();
        params.setSchematronFileDirpath(parser.getArtefactDirpath());
        params.setSchemaFileDirpath(parser.getArtefactDirpath());
        params.setTemporaryDirpath(parser.getOutputDirpath());
        params.setSourceDirpath(parser.getSourceDirpath());
        if (parser.shouldCompile()) {
            params.setExtendedParam("x_write_class_files", "true");
            System.out.println("Compiling rule classes and writing to output directory (" + parser.getOutputDirpath() + ")...");
            params.setExtendedParam("x_write_classes_property_file", "true");
        } else {
            params.setExtendedParam("x_write_class_files", "false");
        }
        if (parser.isSourceRequested()) {
            params.setExtendedParam("x_write_source_code", "true");
            System.out.println("Compiling rule sources and writing to output directory (" + parser.getSourceDirpath() + ")...");
        }
        SchematronValidatorFactories.createStaticCompilingValidatorFactory(params);
    }
}

