/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron;

import com.gsl.schematron.OptionNameAndValue;
import com.gsl.schematron.SchematronCompilerArgParseException;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Random;
import java.util.Set;

public class SchematronCompilerArgParser {
    private static final String JAR_FILEPATH_OPTION_NAME = "-jar";
    private static final String ARTEFACT_DIRPATH_OPTION_NAME = "-a";
    private static final String OUTPUT_DIRPATH_OPTION_NAME = "-o";
    private static final String SOURCE_DIRPATH_OPTION_NAME = "-source";
    private static final Set<String> RECOGNISED_PAIRED_OPTION_NAMES = new HashSet<String>(Arrays.asList("-jar", "-a", "-o", "-source"));
    private String artefactDirpath;
    private String outputDirpath;
    private boolean outputDirSpecified = false;
    private boolean tempDirpath;
    private String jarFilepath;
    private String sourceDirpath;

    public SchematronCompilerArgParser(String ... args) throws SchematronCompilerArgParseException {
        Set<OptionNameAndValue> options = this.parseArguments(args);
        this.extractAndRemoveArtefactDirpath(options);
        this.extractAndRemoveOutputDirpath(options);
        this.extractAndRemoveJarFilepath(options);
        this.extractAndRemoveSourceDirpath(options);
        this.validateOptions();
    }

    private Set<OptionNameAndValue> parseArguments(String[] args) throws SchematronCompilerArgParseException {
        LinkedHashSet<OptionNameAndValue> options = new LinkedHashSet<OptionNameAndValue>();
        for (int i = 0; i < args.length; ++i) {
            OptionNameAndValue option;
            String arg = args[i];
            if (RECOGNISED_PAIRED_OPTION_NAMES.contains(arg)) {
                if (i < args.length - 1 && !RECOGNISED_PAIRED_OPTION_NAMES.contains(args[i + 1])) {
                    option = new OptionNameAndValue(arg, args[++i]);
                    options.add(option);
                    continue;
                }
                throw new SchematronCompilerArgParseException("Value for option \"" + arg + "\" is missing.");
            }
            option = new OptionNameAndValue(null, arg);
            options.add(option);
        }
        return options;
    }

    private void extractAndRemoveOutputDirpath(Set<OptionNameAndValue> options) {
        Iterator<OptionNameAndValue> i = options.iterator();
        while (i.hasNext()) {
            OptionNameAndValue option = i.next();
            if (option.name != null && !option.name.equals(OUTPUT_DIRPATH_OPTION_NAME)) continue;
            this.outputDirpath = option.value;
            i.remove();
            break;
        }
        if (this.outputDirpath == null) {
            this.tempDirpath = true;
            Random generator = new Random();
            String tempSubdir = String.valueOf(Math.abs(generator.nextInt()));
            this.outputDirpath = System.getProperty("java.io.tmpdir") + File.separator + tempSubdir + File.separator;
        } else {
            this.outputDirSpecified = true;
        }
    }

    private void extractAndRemoveArtefactDirpath(Set<OptionNameAndValue> options) {
        Iterator<OptionNameAndValue> i = options.iterator();
        while (i.hasNext()) {
            OptionNameAndValue option = i.next();
            if (option.name != null && !option.name.equals(ARTEFACT_DIRPATH_OPTION_NAME)) continue;
            this.artefactDirpath = option.value;
            i.remove();
            break;
        }
    }

    private void extractAndRemoveJarFilepath(Set<OptionNameAndValue> options) {
        Iterator<OptionNameAndValue> i = options.iterator();
        while (i.hasNext()) {
            OptionNameAndValue option = i.next();
            if (option.name == null || !option.name.equals(JAR_FILEPATH_OPTION_NAME)) continue;
            this.jarFilepath = option.value;
            i.remove();
            break;
        }
    }

    private void extractAndRemoveSourceDirpath(Set<OptionNameAndValue> options) {
        Iterator<OptionNameAndValue> i = options.iterator();
        while (i.hasNext()) {
            OptionNameAndValue option = i.next();
            if (option.name != null && !option.name.equals(SOURCE_DIRPATH_OPTION_NAME)) continue;
            this.sourceDirpath = option.value;
            i.remove();
            break;
        }
    }

    private void validateOptions() throws SchematronCompilerArgParseException {
        if (this.artefactDirpath == null) {
            throw new SchematronCompilerArgParseException("Artefact dirpath must be specified.");
        }
        File artefactDirectory = new File(this.artefactDirpath);
        if (!artefactDirectory.isDirectory()) {
            throw new SchematronCompilerArgParseException("The artefact path is not a valid directory");
        }
    }

    public String getArtefactDirpath() {
        return this.artefactDirpath;
    }

    public String getJarFilepath() {
        return this.jarFilepath;
    }

    public String getOutputDirpath() {
        return this.outputDirpath;
    }

    public boolean isOutputRequested() {
        return this.outputDirpath != null && !this.tempDirpath;
    }

    public String getSourceDirpath() {
        return this.sourceDirpath;
    }

    public boolean isSourceRequested() {
        return this.sourceDirpath != null;
    }

    public boolean shouldCompile() {
        return !this.isSourceRequested() || this.outputDirSpecified;
    }

    public boolean isJarRequested() {
        return this.jarFilepath != null;
    }
}

