/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.generator;

import com.gsl.schematron.generator.ByteArrayClassLoader;
import com.gsl.schematron.generator.ByteCode;
import com.gsl.schematron.generator.ByteCodeResult;
import com.gsl.schematron.generator.ClassGenerator;
import com.gsl.schematron.generator.ClassGeneratorException;
import com.gsl.schematron.generator.ClassResult;
import com.gsl.schematron.generator.ClassResultBuilder;
import java.util.Set;

public class ClassGeneratorImpl
implements ClassGenerator {
    @Override
    public ClassResult generate(ByteCodeResult byteCodeResult) throws ClassGeneratorException {
        ByteArrayClassLoader classLoader = new ByteArrayClassLoader(byteCodeResult.getByteCodes());
        ClassResultBuilder builder = new ClassResultBuilder(classLoader);
        try {
            for (ByteCode byteCode : byteCodeResult.getByteCodes()) {
                Class<?> clazz = classLoader.loadClass(byteCode.getName());
                Set<String> classNamespaces = byteCode.getApplicableNamespaces();
                for (String classNamespace : classNamespaces) {
                    builder.add(classNamespace, clazz);
                }
            }
        }
        catch (ClassNotFoundException cnfEx) {
            throw new ClassGeneratorException(cnfEx);
        }
        return builder.makeClassResult();
    }
}

