/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.generator;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassResult {
    private final Map<String, Set<Class<?>>> namespaceToClassesMap;
    private final ClassLoader classloader;

    public ClassResult(Map<String, Set<Class<?>>> namespaceToClassesMap, ClassLoader classloader) {
        this.namespaceToClassesMap = namespaceToClassesMap;
        this.classloader = classloader;
    }

    public Collection<Class<?>> getAllClasses() {
        HashSet allClasses = new HashSet();
        for (Set<Class<?>> classesForNamespace : this.namespaceToClassesMap.values()) {
            allClasses.addAll(classesForNamespace);
        }
        return allClasses;
    }

    public Collection<Class<?>> getClassesForNamespace(String namespace) {
        Set<Class<Object>> classesForNamespace = this.namespaceToClassesMap.get(namespace);
        if (classesForNamespace == null) {
            classesForNamespace = Collections.emptySet();
        }
        return Collections.unmodifiableSet(classesForNamespace);
    }

    public Collection<String> getAllNamespaces() {
        return this.namespaceToClassesMap.keySet();
    }

    public ClassLoader getClassLoader() {
        return this.classloader;
    }
}

