/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.generator.javac;

import com.gsl.schematron.generator.javac.SourceCode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ClassToNamespacesMap {
    private final Map<String, Set<String>> namespacesMap = new HashMap<String, Set<String>>();

    public ClassToNamespacesMap(Set<SourceCode> sourceCodes) {
        for (SourceCode sourceCode : sourceCodes) {
            String qualifiedClassName = sourceCode.getPackageName() + "." + sourceCode.getClassName();
            this.namespacesMap.put(qualifiedClassName, sourceCode.getApplicableNamespaces());
        }
    }

    public boolean containsKeyForClassName(String qualifiedClassName) {
        String mapKey = this.convertToQualifiedOuterClassName(qualifiedClassName);
        boolean containsKey = this.namespacesMap.containsKey(mapKey);
        return containsKey;
    }

    public Set<String> getNamespacesForClassName(String qualifiedClassName) {
        Set<String> namespaces = Collections.emptySet();
        String mapKey = this.convertToQualifiedOuterClassName(qualifiedClassName);
        if (this.namespacesMap.containsKey(mapKey)) {
            namespaces = this.namespacesMap.get(mapKey);
        }
        return namespaces;
    }

    private String convertToQualifiedOuterClassName(String qualifiedClassName) {
        int lastDollarSignIndex = qualifiedClassName.indexOf(36);
        String qualifiedOuterClassName = lastDollarSignIndex != -1 ? qualifiedClassName.substring(0, lastDollarSignIndex) : qualifiedClassName;
        return qualifiedOuterClassName;
    }
}

