/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.generator.javac;

import com.gsl.logging.LoggerFactory;
import com.gsl.schematron.RuleGeneratorParams;
import com.gsl.schematron.generator.ByteCode;
import com.gsl.schematron.generator.ByteCodeGenerationException;
import com.gsl.schematron.generator.ByteCodeGenerator;
import com.gsl.schematron.generator.ByteCodeResult;
import com.gsl.schematron.generator.javac.SourceCode;
import com.gsl.schematron.generator.javac.VelocityHelper;
import com.gsl.schematron.transformer.Compilable;
import com.gsl.schematron.transformer.CompilableResult;
import com.gsl.util.classlookup.PropertiesFileClassCollector;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.Compiler;
import org.eclipse.jdt.internal.compiler.DefaultErrorHandlingPolicies;
import org.eclipse.jdt.internal.compiler.ICompilerRequestor;
import org.eclipse.jdt.internal.compiler.IErrorHandlingPolicy;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;

public class JDTByteCodeGenerator
implements ByteCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger("schematron.generator");
    public static final String X_PROP_WRITE_SOURCE_CODE = "x_write_source_code";
    public static final String X_PROP_WRITE_CLASS_FILES = "x_write_class_files";
    public static final String X_PROP_WRITE_CLASSES_PROPERTY_FILE = "x_write_classes_property_file";
    private static final char[] NO_FILENAME = new char[0];
    private Map<String, SourceCode> sourceCodes;
    private boolean hasCompilerErrors = false;
    private File outputRootDir;
    private File sourceRootDir;
    private boolean compileSourceCode = true;
    private boolean writeSourceCode = false;
    private boolean writeClassFiles = false;
    private boolean writeClassesPropertyFile = false;
    private String basePackageName = null;
    private String classesPropertyFileDirpath = null;

    public JDTByteCodeGenerator(RuleGeneratorParams ruleGeneratorParams) {
        this.writeClassFiles = ruleGeneratorParams.getExtendedParams().getBoolean(X_PROP_WRITE_CLASS_FILES, true);
        if (this.writeClassFiles) {
            this.outputRootDir = new File(ruleGeneratorParams.getTemporaryDirpath());
        } else {
            this.setCompileSourceCode(false);
        }
        this.writeSourceCode = ruleGeneratorParams.getExtendedParams().getBoolean(X_PROP_WRITE_SOURCE_CODE, false);
        if (this.writeSourceCode) {
            this.sourceRootDir = new File(ruleGeneratorParams.getSourceDirpath());
        }
        this.writeClassesPropertyFile = ruleGeneratorParams.getExtendedParams().getBoolean(X_PROP_WRITE_CLASSES_PROPERTY_FILE, false);
        if (this.writeClassesPropertyFile) {
            this.basePackageName = ruleGeneratorParams.getGeneratorRootJavaPackage();
            this.classesPropertyFileDirpath = this.basePackageName.replace('.', '/');
        }
    }

    public void setOutputRootDir(File outputRootDir) {
        this.outputRootDir = outputRootDir;
    }

    public void setCompileSourceCode(boolean compileSourceCode) {
        this.compileSourceCode = compileSourceCode;
    }

    public void setWriteSourceCode(boolean writeSourceCode) {
        this.writeSourceCode = writeSourceCode;
    }

    public void setWriteClassFiles(boolean writeClassFiles) {
        this.writeClassFiles = writeClassFiles;
    }

    public void setWriteClassesPropertyFile(boolean writeClassesPropertyFile) {
        this.writeClassesPropertyFile = writeClassesPropertyFile;
    }

    @Override
    public ByteCodeResult generate(CompilableResult compilableResult) throws ByteCodeGenerationException {
        this.hasCompilerErrors = false;
        HashMap<String, SourceCode> sourceCodes = new HashMap<String, SourceCode>();
        for (Compilable compilable : compilableResult.getCompilables()) {
            SourceCode sourceCode = VelocityHelper.runVelocityTemplates(compilable);
            if (sourceCode == null) continue;
            sourceCodes.put(sourceCode.getFullyQualifiedClassName(), sourceCode);
            sourceCode.setApplicableNamespaces(compilable.getApplicableNamespaces());
        }
        ByteCodeResult byteCodeResult = this.generate(sourceCodes);
        return byteCodeResult;
    }

    public ByteCodeResult generate(Map<String, SourceCode> sourceCodes) throws ByteCodeGenerationException {
        this.sourceCodes = sourceCodes;
        try {
            if (this.writeSourceCode && this.sourceRootDir != null) {
                for (SourceCode sourceCode : sourceCodes.values()) {
                    this.writeSourceCodeToFile(sourceCode);
                }
            }
            if (this.writeClassesPropertyFile && this.outputRootDir != null) {
                this.writeClassesPropertyFile(sourceCodes);
            }
            ByteCodeResult byteCodeResult = new ByteCodeResult();
            if (this.compileSourceCode) {
                byteCodeResult = this.compileSourceCode();
                if (this.writeClassFiles && this.outputRootDir != null) {
                    for (ByteCode byteCode : byteCodeResult.getByteCodes()) {
                        this.writeClassToFile(byteCode);
                    }
                }
            }
            return byteCodeResult;
        }
        catch (IOException ioEx) {
            throw new ByteCodeGenerationException(ioEx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeClassesPropertyFile(Map<String, SourceCode> sourceCodes) throws IOException {
        String className2;
        String classesPropertyFilepath;
        File classesPropertyFile;
        TreeSet<String> classNames = new TreeSet<String>();
        File outputDir = new File(this.outputRootDir, this.classesPropertyFileDirpath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        if ((classesPropertyFile = new File(this.outputRootDir, classesPropertyFilepath = PropertiesFileClassCollector.createPropertiesPathAndFilename(this.basePackageName, null))).exists()) {
            BufferedReader reader = new BufferedReader(new FileReader(classesPropertyFile));
            String line = reader.readLine();
            while (line != null) {
                className2 = line.substring(0, line.length() - 1);
                classNames.add(className2);
                line = reader.readLine();
            }
        }
        for (SourceCode sourceCode : sourceCodes.values()) {
            className2 = sourceCode.getFullyQualifiedClassName();
            classNames.add(className2);
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(classesPropertyFile));){
            for (String className2 : classNames) {
                writer.write(className2 + "=");
                writer.newLine();
            }
        }
    }

    @Override
    public void postGenerationTearDown() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeSourceCodeToFile(SourceCode sourceCode) throws IOException {
        String packagePath = sourceCode.getPackageName().replace('.', '/');
        File outputDir = new File(this.sourceRootDir, packagePath);
        if (!outputDir.exists()) {
            outputDir.mkdirs();
        }
        File sourceCodeFile = new File(outputDir, sourceCode.getClassName() + ".java");
        try (OutputStreamWriter writer = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(sourceCodeFile)));){
            writer.write(sourceCode.getText());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeClassToFile(ByteCode byteCode) throws IOException {
        File outputDir;
        String className = byteCode.getName();
        String packagePath = "";
        int index = className.lastIndexOf(46);
        if (index > 0) {
            packagePath = className.substring(0, index).replace('.', '/');
            className = className.substring(index + 1, className.length());
        }
        if (!(outputDir = new File(this.outputRootDir, packagePath)).exists()) {
            outputDir.mkdirs();
        }
        File classFile = new File(outputDir, className + ".class");
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(classFile));){
            ((OutputStream)output).write(byteCode.getBytes());
        }
    }

    protected ByteCodeResult compileSourceCode() throws ByteCodeGenerationException {
        final URLClassLoader classLoader = new URLClassLoader(new URL[0]);
        final HashSet<ByteCode> byteCodes = new HashSet<ByteCode>();
        INameEnvironment env = new INameEnvironment(){

            public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
                String typeNameStr = JDTByteCodeGenerator.toCompoundNameString(compoundTypeName);
                return this.findType(typeNameStr);
            }

            public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
                String typeNameStr = JDTByteCodeGenerator.toCompoundNameString(packageName) + '.' + new String(typeName);
                return this.findType(typeNameStr);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private NameEnvironmentAnswer findType(String className) {
                block23: {
                    NameEnvironmentAnswer nameEnvironmentAnswer;
                    InputStream is = null;
                    try {
                        int count;
                        SourceCode sourceCode = (SourceCode)JDTByteCodeGenerator.this.sourceCodes.get(className);
                        if (sourceCode != null) {
                            class CompilationUnit
                            implements ICompilationUnit {
                                final SourceCode sourceCode;

                                CompilationUnit(SourceCode sourceCode) {
                                    this.sourceCode = sourceCode;
                                }

                                public char[] getFileName() {
                                    return NO_FILENAME;
                                }

                                public char[] getContents() {
                                    return this.sourceCode.getText().toCharArray();
                                }

                                public char[] getMainTypeName() {
                                    return this.sourceCode.getClassName().toCharArray();
                                }

                                public char[][] getPackageName() {
                                    String[] subPackages = this.sourceCode.getPackageName().split("\\.");
                                    char[][] result = new char[subPackages.length][];
                                    for (int i = 0; i < result.length; ++i) {
                                        result[i] = subPackages[i].toCharArray();
                                    }
                                    return result;
                                }

                                public boolean ignoreOptionalProblems() {
                                    return false;
                                }
                            }
                            NameEnvironmentAnswer nameEnvironmentAnswer2 = new NameEnvironmentAnswer((ICompilationUnit)new CompilationUnit(sourceCode), null);
                            return nameEnvironmentAnswer2;
                        }
                        String resourceName = className.replace('.', '/') + ".class";
                        is = classLoader.getResourceAsStream(resourceName);
                        if (is == null) break block23;
                        byte[] buf = new byte[8192];
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
                        while ((count = is.read(buf, 0, buf.length)) > 0) {
                            baos.write(buf, 0, count);
                        }
                        baos.flush();
                        byte[] classBytes = baos.toByteArray();
                        char[] fileName = className.toCharArray();
                        ClassFileReader classFileReader = new ClassFileReader(classBytes, fileName, true);
                        nameEnvironmentAnswer = new NameEnvironmentAnswer((IBinaryType)classFileReader, null);
                    }
                    catch (IOException exc) {
                        log.log(Level.SEVERE, "Compilation error", exc);
                        break block23;
                    }
                    catch (ClassFormatException exc) {
                        log.log(Level.SEVERE, "Compilation error", exc);
                        break block23;
                    }
                    finally {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException exc) {}
                        }
                    }
                    return nameEnvironmentAnswer;
                }
                return null;
            }

            private boolean isPackage(String result) {
                if (JDTByteCodeGenerator.this.sourceCodes.containsKey(result)) {
                    return false;
                }
                String resourceName = result.replace('.', '/') + ".class";
                InputStream is = classLoader.getResourceAsStream(resourceName);
                return is == null;
            }

            public boolean isPackage(char[][] parentPackageName, char[] packageName) {
                String parentPackageNameStr = JDTByteCodeGenerator.toCompoundNameString(parentPackageName);
                String packageNameStr = new String(packageName);
                if (Character.isUpperCase(packageNameStr.charAt(0)) && !this.isPackage(parentPackageNameStr)) {
                    return false;
                }
                parentPackageNameStr = parentPackageNameStr + '.' + packageNameStr;
                return this.isPackage(parentPackageNameStr);
            }

            public void cleanup() {
            }
        };
        IErrorHandlingPolicy policy = DefaultErrorHandlingPolicies.proceedWithAllProblems();
        String compilerVersion = "1.7";
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("org.eclipse.jdt.core.compiler.debug.lineNumber", "generate");
        settings.put("org.eclipse.jdt.core.compiler.debug.sourceFile", "generate");
        settings.put("org.eclipse.jdt.core.compiler.problem.deprecation", "ignore");
        settings.put("org.eclipse.jdt.core.compiler.source", "1.7");
        settings.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", "1.7");
        settings.put("org.eclipse.jdt.core.compiler.compliance", "1.7");
        CompilerOptions options = new CompilerOptions(settings);
        DefaultProblemFactory problemFactory = new DefaultProblemFactory(Locale.getDefault());
        ICompilerRequestor requestor = new ICompilerRequestor(){

            public void acceptResult(CompilationResult result) {
                if (result.hasProblems()) {
                    CategorizedProblem[] problems;
                    for (CategorizedProblem categorizedProblem : problems = result.getProblems()) {
                        if (!categorizedProblem.isError()) continue;
                        JDTByteCodeGenerator.this.hasCompilerErrors = true;
                        log.log(Level.SEVERE, categorizedProblem.getMessage());
                    }
                }
                if (!JDTByteCodeGenerator.this.hasCompilerErrors) {
                    ClassFile[] classFiles = result.getClassFiles();
                    for (CategorizedProblem categorizedProblem : classFiles) {
                        String className = JDTByteCodeGenerator.toCompoundNameString(categorizedProblem.getCompoundName());
                        byte[] bytes = categorizedProblem.getBytes();
                        String mainClassName = className;
                        int index = mainClassName.indexOf(36);
                        if (index != -1) {
                            mainClassName = mainClassName.substring(0, index);
                        }
                        Set<String> applicableNamespaces = ((SourceCode)JDTByteCodeGenerator.this.sourceCodes.get(mainClassName)).getApplicableNamespaces();
                        ByteCode byteCode = new ByteCode(applicableNamespaces, className, bytes);
                        byteCodes.add(byteCode);
                    }
                }
            }
        };
        ICompilationUnit[] compilationUnits = new ICompilationUnit[this.sourceCodes.size()];
        int index = 0;
        for (SourceCode sourceCode : this.sourceCodes.values()) {
            compilationUnits[index++] = new CompilationUnit(sourceCode);
        }
        Compiler compiler = new Compiler(env, policy, options.getMap(), requestor, (IProblemFactory)problemFactory);
        compiler.compile(compilationUnits);
        if (this.hasCompilerErrors) {
            throw new ByteCodeGenerationException("compilation problems found");
        }
        return new ByteCodeResult(byteCodes);
    }

    private static String toCompoundNameString(char[][] compoundName) {
        StringBuilder builder = new StringBuilder();
        if (compoundName != null) {
            String sep = "";
            for (char[] subName : compoundName) {
                builder.append(sep).append(new String(subName));
                sep = ".";
            }
        }
        return builder.toString();
    }
}

