/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.generator.javac;

import com.gsl.util.HashCode;
import java.util.Set;

public class SourceCode {
    private final String packageName;
    private final String className;
    private final String fqClassName;
    private String text;
    private Set<String> applicableNamespaces;
    private int hashCode;

    public SourceCode(String packageName, String className) {
        this.packageName = packageName;
        this.className = className;
        this.calculateHashCode();
        String fqClassName = className;
        if (packageName != null && packageName.length() > 0) {
            fqClassName = packageName + '.' + fqClassName;
        }
        this.fqClassName = fqClassName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFullyQualifiedClassName() {
        return this.fqClassName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Set<String> getApplicableNamespaces() {
        return this.applicableNamespaces;
    }

    public void setApplicableNamespaces(Set<String> applicableNamespaces) {
        this.applicableNamespaces = applicableNamespaces;
    }

    private void calculateHashCode() {
        int hashCode = 23;
        hashCode = HashCode.hash(hashCode, this.packageName);
        this.hashCode = hashCode = HashCode.hash(hashCode, this.className);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        SourceCode other = (SourceCode)o;
        return this.packageName.equals(other.packageName) && this.className.equals(other.className);
    }

    public String toString() {
        return "\n" + this.packageName + "." + this.className + "\n" + this.text + "\n";
    }
}

