/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.generator.javac;

import com.gsl.logging.LoggerFactory;
import com.gsl.schematron.generator.javac.SourceCode;
import com.gsl.schematron.transformer.Compilable;
import com.gsl.schematron.transformer.CompilableClass;
import com.gsl.schematron.transformer.DefinitionContext;
import com.gsl.schematron.transformer.SchematronTransformerException;
import com.gsl.schematron.transformer.SchematronTransformerUtil;
import com.gsl.schematron.transformer.ValidatorInitialiserClassDef;
import com.gsl.schematron.transformer.def.RuleClassDef;
import com.gsl.schematron.transformer.ruleclass.ClassGenerator;
import com.gsl.schematron.transformer.ruleclass.RuleClass;
import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.log.LogSystem;
import org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader;

public final class VelocityHelper {
    private static final Logger log = LoggerFactory.getLogger("schematron.generator");
    private static final String RULE_TEMPLATE_NAME = "rule.vm";
    private static final Template RULE_TEMPLATE;
    private static final String RULE3_TEMPLATE_NAME = "rule3.vm";
    private static final Template RULE3_TEMPLATE;
    private static final String INITIALISER_TEMPLATE_NAME = "initialiser.vm";
    private static final Template INITIALISER_TEMPLATE;
    private static final VelocityEngine velocityEngine;
    private static boolean enableLogging;

    private VelocityHelper() {
    }

    public static SourceCode runVelocityTemplates(Compilable compilable) {
        try {
            String code = null;
            if (compilable instanceof CompilableClass) {
                CompilableClass compilableClass = (CompilableClass)compilable;
                if (compilableClass instanceof RuleClassDef) {
                    RuleClassDef def = (RuleClassDef)compilable;
                    if (def.useNewClassTemplate()) {
                        RuleClass ruleClass = ClassGenerator.generate(def);
                        code = VelocityHelper.runTemplate(((RuleClassDef)compilable).getContext(), RULE3_TEMPLATE, ruleClass, "class");
                    } else {
                        code = VelocityHelper.runTemplate(((RuleClassDef)compilable).getContext(), RULE_TEMPLATE, compilable, "def");
                    }
                } else if (compilable instanceof ValidatorInitialiserClassDef) {
                    code = VelocityHelper.runTemplate(null, INITIALISER_TEMPLATE, compilable, "def");
                }
                if (code != null) {
                    SourceCode sourceCode = new SourceCode(compilableClass.getPackageName(), compilableClass.getClassName());
                    sourceCode.setText(code);
                    return sourceCode;
                }
            }
            log.log(Level.SEVERE, "could not handle compilable, unknown nature: " + compilable);
            return null;
        }
        catch (Exception e) {
            throw new SchematronTransformerException(e);
        }
    }

    private static String runTemplate(DefinitionContext context, Template template, Object def, String varName) throws Exception {
        VelocityContext vc = new VelocityContext();
        if (context != null) {
            vc.put("ctx", (Object)context);
        }
        vc.put("util", (Object)SchematronTransformerUtil.INSTANCE);
        vc.put(varName, def);
        StringWriter writer = new StringWriter();
        template.merge((Context)vc, (Writer)writer);
        ((Writer)writer).flush();
        ((Writer)writer).close();
        return ((Object)writer).toString();
    }

    static {
        enableLogging = false;
        VelocityEngine engine = new VelocityEngine();
        try {
            LogSystem logSystem = new LogSystem(){

                public void init(RuntimeServices services) throws Exception {
                }

                public void logVelocityMessage(int level, String message) {
                    if (enableLogging) {
                        switch (level) {
                            case 0: {
                                log.log(Level.FINE, message);
                                break;
                            }
                            case 1: {
                                log.log(Level.INFO, message);
                                break;
                            }
                            case 2: {
                                log.log(Level.WARNING, message);
                                break;
                            }
                            case 3: {
                                log.log(Level.SEVERE, message);
                            }
                        }
                    }
                }
            };
            engine.setProperty("runtime.log.logsystem", (Object)logSystem);
            engine.setProperty("resource.loader", (Object)"class");
            engine.setProperty("class.resource.loader.class", (Object)ClasspathResourceLoader.class.getName());
            engine.init();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "failed to initialise Velocity", e);
        }
        velocityEngine = engine;
        try {
            RULE_TEMPLATE = velocityEngine.getTemplate(RULE_TEMPLATE_NAME);
            RULE3_TEMPLATE = velocityEngine.getTemplate(RULE3_TEMPLATE_NAME);
            INITIALISER_TEMPLATE = velocityEngine.getTemplate(INITIALISER_TEMPLATE_NAME);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

