/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.datetime;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeTimezone {
    private final Pattern dateWithOptionalTimezonePattern = Pattern.compile("([\\d-]+)(T[\\d:.]+)?(Z|[+-]\\d\\d:\\d\\d)?");
    public final String original;
    public String datePart;
    public String timePart;
    public String timezonePart;

    public DateTimeTimezone(String dateTimeString) throws Error {
        this.original = dateTimeString;
        Matcher m = this.dateWithOptionalTimezonePattern.matcher(dateTimeString);
        if (!m.matches()) {
            throw new IllegalArgumentException("Could not parse date string '" + dateTimeString + "'");
        }
        this.datePart = DateTimeTimezone.checkNull(m.group(1));
        this.timePart = DateTimeTimezone.checkNull(m.group(2));
        this.timezonePart = DateTimeTimezone.checkNull(m.group(3));
    }

    public String buildJodaTimeISO8601String() {
        String result = this.datePart;
        if (this.hasTimePart()) {
            result = result + "T" + this.timePart;
            if (this.hasTimezonePart()) {
                result = result + this.timezonePart;
            }
        } else if (this.hasTimezonePart()) {
            result = result + "T" + this.timezonePart;
        }
        return result;
    }

    private static String checkNull(String val) {
        return val == null ? "" : val;
    }

    public boolean hasDatePart() {
        return this.datePart.length() > 0;
    }

    public boolean hasTimePart() {
        return this.timePart.length() > 0;
    }

    public boolean hasTimezonePart() {
        return this.timezonePart.length() > 0;
    }

    public boolean isMorePreciseThan(DateTimeTimezone that) {
        boolean result = false;
        result = this.hasTimePart() && !that.hasTimePart();
        return result;
    }
}

