/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.datetime;

import com.gsl.schematron.support.datetime.DateTimeTimezone;
import com.gsl.schematron.support.datetime.XsDateType;
import com.gsl.schematron.support.datetime.XsDuration;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.PeriodType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class XsDate
extends XsDateType {
    private static DateTimeFormatter FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd");
    private static DateTimeFormatter ISO_FORMAT = DateTimeFormat.forPattern("yyyy-MM-ddZ");
    private static DateTimeFormatter LONDON_PARSER = ISODateTimeFormat.dateParser().withChronology(ISOChronology.getInstance(DateTimeZone.forID("Europe/London")));
    private static DateTimeFormatter PARSER = ISODateTimeFormat.dateParser().withChronology(ISOChronology.getInstanceUTC());

    public static XsDateType parse(String string) {
        DateTimeTimezone dtt = new DateTimeTimezone(string);
        String jodaString = dtt.buildJodaTimeISO8601String();
        XsDate result = dtt.hasTimezonePart() ? new XsDate(PARSER.parseDateTime(jodaString)) : new XsDate(LONDON_PARSER.parseDateTime(jodaString));
        return result;
    }

    @Override
    public String toXMLSchemaString() {
        return ISO_FORMAT.print(this.asDateTime());
    }

    public XsDate(DateTime dt) {
        super(dt);
    }

    @Override
    public XsDateType add(XsDuration duration) {
        return new XsDate(this.asDateTime().plus(duration.asPeriod()));
    }

    @Override
    protected int ranking() {
        return 3;
    }

    @Override
    protected XsDateType cast(XsDateType date) {
        if (date.getClass() != this.getClass()) {
            date = new XsDate(date.asDateTime());
        }
        return date;
    }

    @Override
    protected PeriodType getPeriodType() {
        return PeriodType.dayTime();
    }

    public String toString() {
        return FORMAT.print(this.asDateTime().toLocalDate());
    }

    @Override
    public XsDateType convertDateToMyPrecision(XsDateType that) {
        DateTime thatDateTime = that.asDateTime();
        Chronology chronology = thatDateTime.getChronology();
        return new XsDate(new DateTime(thatDateTime.getYear(), thatDateTime.getMonthOfYear(), thatDateTime.getDayOfMonth(), 0, 0, 0, 0, chronology));
    }

    @Override
    protected boolean hasDay() {
        return true;
    }

    @Override
    protected boolean hasMonth() {
        return true;
    }

    @Override
    protected boolean hasTime() {
        return false;
    }

    @Override
    protected boolean hasYear() {
        return true;
    }
}

