/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.datetime;

import com.gsl.schematron.support.datetime.DateTimeTimezone;
import com.gsl.schematron.support.datetime.XsDateType;
import com.gsl.schematron.support.datetime.XsDuration;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.PeriodType;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class XsDateTime
extends XsDateType {
    private static DateTimeFormatter FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss");
    private static DateTimeFormatter ISO_FORMAT = DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ssZ");
    private static DateTimeFormatter LONDON_PARSER = ISODateTimeFormat.dateTimeParser().withChronology(ISOChronology.getInstance(DateTimeZone.forID("Europe/London")));
    private static DateTimeFormatter PARSER = ISODateTimeFormat.dateTimeParser().withChronology(ISOChronology.getInstanceUTC());

    public static XsDateTime parse(String dateTimeString) {
        DateTimeTimezone dtt = new DateTimeTimezone(dateTimeString);
        DateTime dt = dtt.hasTimezonePart() ? PARSER.parseDateTime(dateTimeString) : LONDON_PARSER.parseDateTime(dateTimeString);
        dt = dt.minusMillis(dt.getMillisOfSecond());
        XsDateTime dateTime = new XsDateTime(dt);
        return dateTime;
    }

    @Override
    public String toXMLSchemaString() {
        return ISO_FORMAT.print(this.asDateTime());
    }

    public XsDateTime(DateTime date) {
        super(date);
    }

    @Override
    public XsDateType add(XsDuration duration) {
        return new XsDateTime(this.asDateTime().plus(duration.asPeriod()));
    }

    @Override
    protected int ranking() {
        return 4;
    }

    public String toString() {
        return FORMAT.print(this.asDateTime());
    }

    @Override
    protected XsDateType cast(XsDateType date) {
        if (date.getClass() != this.getClass()) {
            date = new XsDateTime(date.asDateTime());
        }
        return date;
    }

    @Override
    protected PeriodType getPeriodType() {
        return PeriodType.dayTime();
    }

    @Override
    public XsDateType convertDateToMyPrecision(XsDateType date2) {
        throw new UnsupportedOperationException("implement me!");
    }

    @Override
    protected boolean hasDay() {
        return true;
    }

    @Override
    protected boolean hasMonth() {
        return true;
    }

    @Override
    protected boolean hasTime() {
        return true;
    }

    @Override
    protected boolean hasYear() {
        return true;
    }
}

