/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.datetime;

import com.gsl.schematron.support.datetime.DateTimeTimezone;
import com.gsl.schematron.support.datetime.XsDate;
import com.gsl.schematron.support.datetime.XsDateTime;
import com.gsl.schematron.support.datetime.XsDuration;
import com.gsl.schematron.support.datetime.XsGDay;
import com.gsl.schematron.support.datetime.XsGMonthDay;
import com.gsl.schematron.support.datetime.XsGYear;
import com.gsl.schematron.support.datetime.XsGYearMonth;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.PeriodType;
import org.joda.time.ReadableInstant;
import org.joda.time.base.BaseDateTime;

public abstract class XsDateType {
    private final DateTime dt;

    protected XsDateType(DateTime dt) {
        this.dt = dt;
    }

    public static XsDateType parseDate(String dateString) {
        DateTimeTimezone dtt = new DateTimeTimezone(dateString);
        if (dtt.hasTimePart()) {
            return XsDateTime.parse(dateString);
        }
        String datePart = dtt.datePart;
        if (datePart.length() > 2 && datePart.charAt(0) == '-' && datePart.charAt(1) == '-') {
            switch (dateString.length()) {
                case 7: {
                    return XsGMonthDay.parse(dateString);
                }
                case 5: {
                    return XsGDay.parse(dateString);
                }
            }
            throw new IllegalArgumentException("invalid date: " + dateString);
        }
        switch (datePart.length()) {
            case 10: 
            case 11: {
                return XsDate.parse(dateString);
            }
            case 7: {
                return XsGYearMonth.parse(dateString);
            }
            case 4: {
                return XsGYear.parse(dateString);
            }
        }
        throw new IllegalArgumentException("invalid date: " + dateString);
    }

    public DateTime asDateTime() {
        return this.dt;
    }

    protected abstract int ranking();

    public abstract XsDateType add(XsDuration var1);

    public XsDuration difference(XsDateType that) {
        XsDuration result;
        long end;
        DateTime thisDt = this.asDateTime().toDateTime(DateTimeZone.UTC);
        DateTime thatDt = that.asDateTime().toDateTime(DateTimeZone.UTC);
        long start = thisDt.getMillis();
        if (start <= (end = thatDt.getMillis())) {
            Period p = new Period((ReadableInstant)thisDt, (ReadableInstant)thatDt, this.getPeriodType());
            result = new XsDuration(p);
        } else {
            Period p = new Period((ReadableInstant)thatDt, (ReadableInstant)thisDt, this.getPeriodType());
            result = new XsDuration(p).negate();
        }
        return result;
    }

    public long differenceInSeconds(XsDateType that) {
        DateTime thisDt = this.asDateTime().toDateTime(DateTimeZone.UTC);
        DateTime thatDt = that.asDateTime().toDateTime(DateTimeZone.UTC);
        long start = thisDt.getMillis();
        long end = thatDt.getMillis();
        long differenceInMillis = end - start;
        return differenceInMillis / 1000L;
    }

    public abstract String toXMLSchemaString();

    protected abstract PeriodType getPeriodType();

    protected abstract XsDateType cast(XsDateType var1);

    public static XsDateType fromBaseDateTime(BaseDateTime dateTime) {
        if (dateTime instanceof DateMidnight) {
            return new XsDate(dateTime.toDateTime());
        }
        return new XsDateTime(dateTime.toDateTime());
    }

    public boolean isMorePreciseThan(XsDateType that) {
        return this.precision() > that.precision();
    }

    protected final long precision() {
        long result = 0L;
        result += this.hasYear() ? 1L : 0L;
        result += this.hasMonth() ? 2L : 0L;
        result += this.hasDay() ? 4L : 0L;
        return result += this.hasTime() ? 8L : 0L;
    }

    protected abstract boolean hasTime();

    protected abstract boolean hasDay();

    protected abstract boolean hasMonth();

    protected abstract boolean hasYear();

    public abstract XsDateType convertDateToMyPrecision(XsDateType var1);
}

