/*
 * Decompiled with CFR 0.152.
 */
package com.gsl.schematron.support.datetime;

import java.text.ParseException;
import java.util.StringTokenizer;
import org.joda.time.Period;

public class XsDuration {
    private final String string;
    private Period period = Period.ZERO;
    public static final XsDuration POSITIVE = XsDuration.parseDuration("P1D");
    public static final XsDuration NEGATIVE = XsDuration.parseDuration("-P1D");

    public static XsDuration parseDuration(String string) {
        try {
            boolean negative;
            int index = 0;
            boolean bl = negative = string.charAt(index) == '-';
            if (negative) {
                ++index;
            }
            if (string.charAt(index) != 'P') {
                return null;
            }
            XsDuration duration = new XsDuration(string);
            string = string.substring(++index);
            boolean seenT = false;
            int Y = 0;
            int M = 0;
            int D = 0;
            int H = 0;
            int m = 0;
            int S = 0;
            int sss = 0;
            Pos pos = new Pos();
            StringTokenizer tokens = new StringTokenizer(string, "YMDHST", true);
            while (tokens.hasMoreTokens()) {
                String delim;
                String str = tokens.nextToken();
                if (str.equals("T")) {
                    seenT = true;
                    str = tokens.nextToken();
                }
                if ((delim = tokens.nextToken()).equals("Y")) {
                    pos.check(1);
                    Y = Integer.parseInt(str);
                    continue;
                }
                if (delim.equals("M")) {
                    if (!seenT || string.indexOf(84) < 0) {
                        pos.check(2);
                        M = Integer.parseInt(str);
                        continue;
                    }
                    pos.check(5);
                    m = Integer.parseInt(str);
                    continue;
                }
                if (delim.equals("D")) {
                    pos.check(3);
                    D = Integer.parseInt(str);
                    continue;
                }
                if (delim.equals("H")) {
                    pos.check(4);
                    H = Integer.parseInt(str);
                    continue;
                }
                if (!delim.equals("S")) continue;
                pos.check(6);
                int dot = str.indexOf(46);
                if (dot < 0) {
                    S = Integer.parseInt(str);
                    continue;
                }
                if (dot == 0) {
                    sss = Integer.parseInt(str.substring(1));
                    continue;
                }
                S = Integer.parseInt(str.substring(0, dot));
                sss = Integer.parseInt(str.substring(dot + 1, str.length()));
            }
            int i = negative ? -1 : 1;
            duration.period = new Period(i * Y, i * M, 0, i * D, i * H, i * m, i * S, i * sss);
            return duration;
        }
        catch (ParseException e) {
            return null;
        }
    }

    private XsDuration(String string) {
        this.string = string;
    }

    public XsDuration(Period p) {
        this.period = p;
        this.string = p.toString();
    }

    public Period asPeriod() {
        return this.period.normalizedStandard();
    }

    public String toString() {
        return this.string;
    }

    public XsDuration negate() {
        String s = this.period.toString();
        s = s.startsWith("-") ? s.substring(1) : "-" + s;
        return XsDuration.parseDuration(s);
    }

    public double toSeconds() {
        double result = this.period.toStandardDuration().getStandardSeconds();
        return result;
    }

    private static final class Pos {
        int pos = 0;

        private Pos() {
        }

        void check(int i) throws ParseException {
            if (this.pos >= i) {
                throw new ParseException("", 0);
            }
            this.pos = i;
        }
    }
}

